/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.IntervalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.NonMergingWindowFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class SlidingWindows
extends NonMergingWindowFn<Object, IntervalWindow> {
    private final Duration period;
    private final Duration size;
    private final Duration offset;

    public static SlidingWindows of(Duration size) {
        return new SlidingWindows(SlidingWindows.getDefaultPeriod(size), size, Duration.ZERO);
    }

    public SlidingWindows every(Duration period) {
        return new SlidingWindows(period, this.size, this.offset);
    }

    public SlidingWindows withOffset(Duration offset) {
        return new SlidingWindows(this.period, this.size, offset);
    }

    private SlidingWindows(Duration period, Duration size, Duration offset) {
        if (offset.isShorterThan((ReadableDuration)Duration.ZERO) || !offset.isShorterThan((ReadableDuration)period) || !size.isLongerThan((ReadableDuration)Duration.ZERO)) {
            throw new IllegalArgumentException("SlidingWindows WindowingStrategies must have 0 <= offset < period and 0 < size");
        }
        this.period = period;
        this.size = size;
        this.offset = offset;
    }

    @Override
    public Coder<IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    @Override
    public Collection<IntervalWindow> assignWindows(WindowFn.AssignContext c) {
        long lastStart;
        ArrayList<IntervalWindow> windows = new ArrayList<IntervalWindow>((int)(this.size.getMillis() / this.period.getMillis()));
        Instant timestamp = c.timestamp();
        for (long start = lastStart = this.lastStartFor(timestamp); start > timestamp.minus((ReadableDuration)this.size).getMillis(); start -= this.period.getMillis()) {
            windows.add(new IntervalWindow(new Instant(start), (ReadableDuration)this.size));
        }
        return windows;
    }

    @Override
    public IntervalWindow getSideInputWindow(BoundedWindow window) {
        if (window instanceof GlobalWindow) {
            throw new IllegalArgumentException("Attempted to get side input window for GlobalWindow from non-global WindowFn");
        }
        long lastStart = this.lastStartFor(window.maxTimestamp().minus((ReadableDuration)this.size));
        return new IntervalWindow(new Instant(lastStart + this.period.getMillis()), (ReadableDuration)this.size);
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        return this.equals(other);
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("size", this.size).withLabel("Window Size")).add(DisplayData.item("period", this.period).withLabel("Window Period")).add(DisplayData.item("offset", this.offset).withLabel("Window Start Offset"));
    }

    private long lastStartFor(Instant timestamp) {
        return timestamp.getMillis() - timestamp.plus((ReadableDuration)this.period).minus((ReadableDuration)this.offset).getMillis() % this.period.getMillis();
    }

    static Duration getDefaultPeriod(Duration size) {
        if (size.isLongerThan((ReadableDuration)Duration.standardHours((long)1L))) {
            return Duration.standardHours((long)1L);
        }
        if (size.isLongerThan((ReadableDuration)Duration.standardMinutes((long)1L))) {
            return Duration.standardMinutes((long)1L);
        }
        if (size.isLongerThan((ReadableDuration)Duration.standardSeconds((long)1L))) {
            return Duration.standardSeconds((long)1L);
        }
        return Duration.millis((long)1L);
    }

    public Duration getPeriod() {
        return this.period;
    }

    public Duration getSize() {
        return this.size;
    }

    public Duration getOffset() {
        return this.offset;
    }

    @Override
    @Experimental(value=Experimental.Kind.OUTPUT_TIME)
    public OutputTimeFn<? super IntervalWindow> getOutputTimeFn() {
        return new OutputTimeFn.Defaults<BoundedWindow>(){

            @Override
            public Instant assignOutputTime(Instant inputTimestamp, BoundedWindow window) {
                Instant startOfLastSegment = window.maxTimestamp().minus((ReadableDuration)SlidingWindows.this.period);
                return startOfLastSegment.isBefore((ReadableInstant)inputTimestamp) ? inputTimestamp : startOfLastSegment.plus(1L);
            }

            @Override
            public boolean dependsOnlyOnEarliestInputTimestamp() {
                return true;
            }
        };
    }

    public boolean equals(Object object) {
        if (!(object instanceof SlidingWindows)) {
            return false;
        }
        SlidingWindows other = (SlidingWindows)object;
        return this.getOffset().equals((Object)other.getOffset()) && this.getSize().equals((Object)other.getSize()) && this.getPeriod().equals((Object)other.getPeriod());
    }

    public int hashCode() {
        return Objects.hash(this.size, this.offset, this.period);
    }
}

