/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.DefaultTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindows;
import com.google.cloud.dataflow.sdk.transforms.windowing.InvalidWindows;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.TriggerBuilder;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import com.google.cloud.dataflow.sdk.util.AssignWindowsDoFn;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.PCollection;
import javax.annotation.Nullable;
import org.joda.time.Duration;

public class Window {
    public static Unbound named(String name) {
        return new Unbound().named(name);
    }

    public static <T> Bound<T> into(WindowFn<? super T, ?> fn) {
        return new Unbound().into(fn);
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public static <T> Bound<T> triggering(TriggerBuilder<?> trigger) {
        return new Unbound().triggering(trigger);
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public static <T> Bound<T> discardingFiredPanes() {
        return new Unbound().discardingFiredPanes();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public static <T> Bound<T> accumulatingFiredPanes() {
        return new Unbound().accumulatingFiredPanes();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public static <T> Bound<T> withAllowedLateness(Duration allowedLateness) {
        return new Unbound().withAllowedLateness(allowedLateness);
    }

    private static <T> PTransform<PCollection<? extends T>, PCollection<T>> identity() {
        return ParDo.named("Identity").of(new DoFn<T, T>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                c.output(c.element());
            }
        });
    }

    public static <T> Remerge<T> remerge() {
        return new Remerge();
    }

    public static class Remerge<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        @Override
        public PCollection<T> apply(PCollection<T> input) {
            WindowingStrategy<?, ?> outputWindowingStrategy = this.getOutputWindowing(input.getWindowingStrategy());
            return ((PCollection)input.apply(Window.identity())).setWindowingStrategyInternal(outputWindowingStrategy);
        }

        private <W extends BoundedWindow> WindowingStrategy<?, W> getOutputWindowing(WindowingStrategy<?, W> inputStrategy) {
            if (inputStrategy.getWindowFn() instanceof InvalidWindows) {
                InvalidWindows invalidWindows = (InvalidWindows)inputStrategy.getWindowFn();
                return inputStrategy.withWindowFn(invalidWindows.getOriginalWindowFn());
            }
            return inputStrategy;
        }
    }

    public static class Bound<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        @Nullable
        private final WindowFn<? super T, ?> windowFn;
        @Nullable
        private final Trigger<?> trigger;
        @Nullable
        private final WindowingStrategy.AccumulationMode mode;
        @Nullable
        private final Duration allowedLateness;
        @Nullable
        private final ClosingBehavior closingBehavior;
        @Nullable
        private final OutputTimeFn<?> outputTimeFn;

        private Bound(String name, @Nullable WindowFn<? super T, ?> windowFn, @Nullable Trigger<?> trigger, @Nullable WindowingStrategy.AccumulationMode mode, @Nullable Duration allowedLateness, ClosingBehavior behavior, @Nullable OutputTimeFn<?> outputTimeFn) {
            super(name);
            this.windowFn = windowFn;
            this.trigger = trigger;
            this.mode = mode;
            this.allowedLateness = allowedLateness;
            this.closingBehavior = behavior;
            this.outputTimeFn = outputTimeFn;
        }

        private Bound(String name) {
            this(name, null, null, null, null, null, null);
        }

        private Bound<T> into(WindowFn<? super T, ?> windowFn) {
            try {
                windowFn.windowCoder().verifyDeterministic();
            }
            catch (Coder.NonDeterministicException e) {
                throw new IllegalArgumentException("Window coders must be deterministic.", e);
            }
            return new Bound<T>(this.name, windowFn, this.trigger, this.mode, this.allowedLateness, this.closingBehavior, this.outputTimeFn);
        }

        public Bound<T> named(String name) {
            return new Bound<T>(name, this.windowFn, this.trigger, this.mode, this.allowedLateness, this.closingBehavior, this.outputTimeFn);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public Bound<T> triggering(TriggerBuilder<?> trigger) {
            return new Bound<T>(this.name, this.windowFn, trigger.buildTrigger(), this.mode, this.allowedLateness, this.closingBehavior, this.outputTimeFn);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public Bound<T> discardingFiredPanes() {
            return new Bound<T>(this.name, this.windowFn, this.trigger, WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, this.allowedLateness, this.closingBehavior, this.outputTimeFn);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public Bound<T> accumulatingFiredPanes() {
            return new Bound<T>(this.name, this.windowFn, this.trigger, WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, this.allowedLateness, this.closingBehavior, this.outputTimeFn);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public Bound<T> withAllowedLateness(Duration allowedLateness) {
            return new Bound<T>(this.name, this.windowFn, this.trigger, this.mode, allowedLateness, this.closingBehavior, this.outputTimeFn);
        }

        @Experimental(value=Experimental.Kind.OUTPUT_TIME)
        public Bound<T> withOutputTimeFn(OutputTimeFn<?> outputTimeFn) {
            return new Bound<T>(this.name, this.windowFn, this.trigger, this.mode, this.allowedLateness, this.closingBehavior, outputTimeFn);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public Bound<T> withAllowedLateness(Duration allowedLateness, ClosingBehavior behavior) {
            return new Bound<T>(this.name, this.windowFn, this.trigger, this.mode, allowedLateness, behavior, this.outputTimeFn);
        }

        public WindowingStrategy<?, ?> getOutputStrategyInternal(WindowingStrategy<?, ?> inputStrategy) {
            WindowingStrategy<Object, Object> result = inputStrategy;
            if (this.windowFn != null) {
                result = result.withWindowFn(this.windowFn);
            }
            if (this.trigger != null) {
                result = result.withTrigger(this.trigger);
            }
            if (this.mode != null) {
                result = result.withMode(this.mode);
            }
            if (this.allowedLateness != null) {
                result = result.withAllowedLateness(this.allowedLateness);
            }
            if (this.closingBehavior != null) {
                result = result.withClosingBehavior(this.closingBehavior);
            }
            if (this.outputTimeFn != null) {
                result = result.withOutputTimeFn(this.outputTimeFn);
            }
            return result;
        }

        public WindowFn<? super T, ?> getWindowFn() {
            return this.windowFn;
        }

        @Override
        public void validate(PCollection<T> input) {
            WindowingStrategy<?, ?> outputStrategy = this.getOutputStrategyInternal(input.getWindowingStrategy());
            if (outputStrategy.isTriggerSpecified() && !(outputStrategy.getTrigger().getSpec() instanceof DefaultTrigger)) {
                if (!(outputStrategy.getWindowFn() instanceof GlobalWindows) && !outputStrategy.isAllowedLatenessSpecified()) {
                    throw new IllegalArgumentException("Except when using GlobalWindows, calling .triggering() to specify a trigger requires that the allowed lateness be specified using .withAllowedLateness() to set the upper bound on how late data can arrive before being dropped. See Javadoc for more details.");
                }
                if (!outputStrategy.isModeSpecified()) {
                    throw new IllegalArgumentException("Calling .triggering() to specify a trigger requires that the accumulation mode be specified using .discardingFiredPanes() or .accumulatingFiredPanes(). See Javadoc for more details.");
                }
            }
        }

        @Override
        public PCollection<T> apply(PCollection<T> input) {
            WindowingStrategy<?, ?> outputStrategy = this.getOutputStrategyInternal(input.getWindowingStrategy());
            PCollection<T> output = this.windowFn != null ? this.assignWindows(input, this.windowFn) : (PCollection<T>)input.apply(Window.identity());
            return output.setWindowingStrategyInternal(outputStrategy);
        }

        private <T, W extends BoundedWindow> PCollection<T> assignWindows(PCollection<T> input, WindowFn<? super T, W> windowFn) {
            return (PCollection)input.apply("AssignWindows", ParDo.of(new AssignWindowsDoFn<T, W>(windowFn)));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            if (this.windowFn != null) {
                builder.add(DisplayData.item("windowFn", this.windowFn.getClass()).withLabel("Windowing Function")).include(this.windowFn);
            }
            if (this.allowedLateness != null) {
                builder.addIfNotDefault(DisplayData.item("allowedLateness", this.allowedLateness).withLabel("Allowed Lateness"), Duration.millis((long)BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()));
            }
            if (this.trigger != null && !(this.trigger instanceof DefaultTrigger)) {
                builder.add(DisplayData.item("trigger", this.trigger.toString()).withLabel("Trigger"));
            }
            if (this.mode != null) {
                builder.add(DisplayData.item("accumulationMode", this.mode.toString()).withLabel("Accumulation Mode"));
            }
            if (this.closingBehavior != null) {
                builder.add(DisplayData.item("closingBehavior", this.closingBehavior.toString()).withLabel("Window Closing Behavior"));
            }
            if (this.outputTimeFn != null) {
                builder.add(DisplayData.item("outputTimeFn", this.outputTimeFn.getClass()).withLabel("Output Time Function"));
            }
        }

        @Override
        protected Coder<?> getDefaultOutputCoder(PCollection<T> input) {
            return input.getCoder();
        }

        @Override
        protected String getKindString() {
            return "Window.Into()";
        }
    }

    public static class Unbound {
        String name;

        Unbound() {
        }

        Unbound(String name) {
            this.name = name;
        }

        public Unbound named(String name) {
            return new Unbound(name);
        }

        public <T> Bound<T> into(WindowFn<? super T, ?> fn) {
            return new Bound(this.name).into(fn);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public <T> Bound<T> triggering(TriggerBuilder<?> trigger) {
            return new Bound(this.name).triggering(trigger);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public <T> Bound<T> discardingFiredPanes() {
            return new Bound(this.name).discardingFiredPanes();
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public <T> Bound<T> accumulatingFiredPanes() {
            return new Bound(this.name).accumulatingFiredPanes();
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public <T> Bound<T> withAllowedLateness(Duration allowedLateness) {
            return new Bound(this.name).withAllowedLateness(allowedLateness);
        }

        @Experimental(value=Experimental.Kind.TRIGGER)
        public <T> Bound<T> withAllowedLateness(Duration allowedLateness, ClosingBehavior behavior) {
            return new Bound(this.name).withAllowedLateness(allowedLateness, behavior);
        }
    }

    public static enum ClosingBehavior {
        FIRE_ALWAYS,
        FIRE_IF_NON_EMPTY;

    }
}

