/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Verify;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.BaseEncoding;
import com.google.cloud.dataflow.sdk.util.IOChannelUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileConstants;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DecoderFactory;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AvroUtils {
    private static final DateTimeFormatter DATE_AND_SECONDS_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC();

    public static AvroMetadata readMetadataFromFile(String fileName) throws IOException {
        byte[] syncMarker;
        String codec = null;
        String schemaString = null;
        try (InputStream stream = Channels.newInputStream(IOChannelUtils.getFactory(fileName).open(fileName));){
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(stream, null);
            byte[] magic = new byte[DataFileConstants.MAGIC.length];
            decoder.readFixed(magic);
            if (!Arrays.equals(magic, DataFileConstants.MAGIC)) {
                throw new IOException("Missing Avro file signature: " + fileName);
            }
            ByteBuffer valueBuffer = ByteBuffer.allocate(512);
            long numRecords = decoder.readMapStart();
            while (numRecords > 0L) {
                for (long recordIndex = 0L; recordIndex < numRecords; ++recordIndex) {
                    String key = decoder.readString();
                    valueBuffer = decoder.readBytes(valueBuffer);
                    byte[] bytes = new byte[valueBuffer.remaining()];
                    valueBuffer.get(bytes);
                    if (key.equals("avro.codec")) {
                        codec = new String(bytes, "UTF-8");
                        continue;
                    }
                    if (!key.equals("avro.schema")) continue;
                    schemaString = new String(bytes, "UTF-8");
                }
                numRecords = decoder.mapNext();
            }
            if (codec == null) {
                codec = "null";
            }
            syncMarker = new byte[16];
            decoder.readFixed(syncMarker);
        }
        return new AvroMetadata(syncMarker, codec, schemaString);
    }

    static String formatTimestamp(String timestamp) {
        double timestampDoubleMicros = Double.parseDouble(timestamp) * 1000000.0;
        long timestampMicros = (long)timestampDoubleMicros;
        long seconds = timestampMicros / 1000000L;
        int micros = (int)(timestampMicros % 1000000L);
        String dayAndTime = DATE_AND_SECONDS_FORMATTER.print(seconds * 1000L);
        if (micros == 0) {
            return String.format("%s UTC", dayAndTime);
        }
        int digits = 6;
        int subsecond = micros;
        while (subsecond % 10 == 0) {
            --digits;
            subsecond /= 10;
        }
        String formatString = String.format("%%0%dd", digits);
        String fractionalSeconds = String.format(formatString, subsecond);
        return String.format("%s.%s UTC", dayAndTime, fractionalSeconds);
    }

    public static TableRow convertGenericRecordToTableRow(GenericRecord record, TableSchema schema) {
        return AvroUtils.convertGenericRecordToTableRow(record, schema.getFields());
    }

    private static TableRow convertGenericRecordToTableRow(GenericRecord record, List<TableFieldSchema> fields) {
        TableRow row = new TableRow();
        for (TableFieldSchema subSchema : fields) {
            Schema.Field field = record.getSchema().getField(subSchema.getName());
            Object convertedValue = AvroUtils.getTypedCellValue(field.schema(), subSchema, record.get(field.name()));
            if (convertedValue == null) continue;
            row.set(field.name(), convertedValue);
        }
        return row;
    }

    @Nullable
    private static Object getTypedCellValue(Schema schema, TableFieldSchema fieldSchema, Object v) {
        String mode;
        switch (mode = MoreObjects.firstNonNull(fieldSchema.getMode(), "NULLABLE")) {
            case "REQUIRED": {
                return AvroUtils.convertRequiredField(schema.getType(), fieldSchema, v);
            }
            case "REPEATED": {
                return AvroUtils.convertRepeatedField(schema, fieldSchema, v);
            }
            case "NULLABLE": {
                return AvroUtils.convertNullableField(schema, fieldSchema, v);
            }
        }
        throw new UnsupportedOperationException("Parsing a field with BigQuery field schema mode " + fieldSchema.getMode());
    }

    private static List<Object> convertRepeatedField(Schema schema, TableFieldSchema fieldSchema, Object v) {
        Schema.Type arrayType = schema.getType();
        Verify.verify(arrayType == Schema.Type.ARRAY, "BigQuery REPEATED field %s should be Avro ARRAY, not %s", fieldSchema.getName(), arrayType);
        if (v == null) {
            return ImmutableList.of();
        }
        List elements = (List)v;
        ImmutableList.Builder values = ImmutableList.builder();
        Schema.Type elementType = schema.getElementType().getType();
        for (Object element : elements) {
            values.add(AvroUtils.convertRequiredField(elementType, fieldSchema, element));
        }
        return values.build();
    }

    private static Object convertRequiredField(Schema.Type avroType, TableFieldSchema fieldSchema, Object v) {
        Preconditions.checkNotNull(v, "REQUIRED field %s should not be null", fieldSchema.getName());
        ImmutableMap<String, Schema.Type> fieldMap = ImmutableMap.builder().put("STRING", Schema.Type.STRING).put("BYTES", Schema.Type.BYTES).put("INTEGER", Schema.Type.LONG).put("FLOAT", Schema.Type.DOUBLE).put("BOOLEAN", Schema.Type.BOOLEAN).put("TIMESTAMP", Schema.Type.LONG).put("RECORD", Schema.Type.RECORD).put("DATE", Schema.Type.STRING).put("DATETIME", Schema.Type.STRING).put("TIME", Schema.Type.STRING).build();
        String bqType = fieldSchema.getType();
        Schema.Type expectedAvroType = fieldMap.get(bqType);
        Verify.verifyNotNull(expectedAvroType, "Unsupported BigQuery type: %s", bqType);
        Verify.verify(avroType == expectedAvroType, "Expected Avro schema type %s, not %s, for BigQuery %s field %s", expectedAvroType, avroType, bqType, fieldSchema.getName());
        switch (fieldSchema.getType()) {
            case "STRING": 
            case "DATE": 
            case "DATETIME": 
            case "TIME": {
                Verify.verify(v instanceof CharSequence, "Expected CharSequence (String), got %s", v.getClass());
                return v.toString();
            }
            case "INTEGER": {
                Verify.verify(v instanceof Long, "Expected Long, got %s", v.getClass());
                return ((Long)v).toString();
            }
            case "FLOAT": {
                Verify.verify(v instanceof Double, "Expected Double, got %s", v.getClass());
                return v;
            }
            case "BOOLEAN": {
                Verify.verify(v instanceof Boolean, "Expected Boolean, got %s", v.getClass());
                return v;
            }
            case "TIMESTAMP": {
                Verify.verify(v instanceof Long, "Expected Long, got %s", v.getClass());
                Double doubleValue = (double)((Long)v).longValue() / 1000000.0;
                return AvroUtils.formatTimestamp(doubleValue.toString());
            }
            case "RECORD": {
                Verify.verify(v instanceof GenericRecord, "Expected GenericRecord, got %s", v.getClass());
                return AvroUtils.convertGenericRecordToTableRow((GenericRecord)v, fieldSchema.getFields());
            }
            case "BYTES": {
                Verify.verify(v instanceof ByteBuffer, "Expected ByteBuffer, got %s", v.getClass());
                ByteBuffer byteBuffer = (ByteBuffer)v;
                byte[] bytes = new byte[byteBuffer.limit()];
                byteBuffer.get(bytes);
                return BaseEncoding.base64().encode(bytes);
            }
        }
        throw new UnsupportedOperationException(String.format("Unexpected BigQuery field schema type %s for field named %s", fieldSchema.getType(), fieldSchema.getName()));
    }

    @Nullable
    private static Object convertNullableField(Schema avroSchema, TableFieldSchema fieldSchema, Object v) {
        Verify.verify(avroSchema.getType() == Schema.Type.UNION, "Expected Avro schema type UNION, not %s, for BigQuery NULLABLE field %s", avroSchema.getType(), fieldSchema.getName());
        List unionTypes = avroSchema.getTypes();
        Verify.verify(unionTypes.size() == 2, "BigQuery NULLABLE field %s should be an Avro UNION of NULL and another type, not %s", fieldSchema.getName(), unionTypes);
        if (v == null) {
            return null;
        }
        Schema.Type firstType = ((Schema)unionTypes.get(0)).getType();
        if (!firstType.equals((Object)Schema.Type.NULL)) {
            return AvroUtils.convertRequiredField(firstType, fieldSchema, v);
        }
        return AvroUtils.convertRequiredField(((Schema)unionTypes.get(1)).getType(), fieldSchema, v);
    }

    public static class AvroMetadata {
        private byte[] syncMarker;
        private String codec;
        private String schemaString;

        AvroMetadata(byte[] syncMarker, String codec, String schemaString) {
            this.syncMarker = syncMarker;
            this.codec = codec;
            this.schemaString = schemaString;
        }

        public String getSchemaString() {
            return this.schemaString;
        }

        public String getCodec() {
            return this.codec;
        }

        public byte[] getSyncMarker() {
            return this.syncMarker;
        }
    }
}

