/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.dataflow.sdk.options.BigQueryOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.util.BigQueryServices;
import com.google.cloud.dataflow.sdk.util.BigQueryTableRowIterator;
import com.google.cloud.dataflow.sdk.util.FluentBackoff;
import com.google.cloud.dataflow.sdk.util.Transport;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryServicesImpl
implements BigQueryServices {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryServicesImpl.class);
    private static final int MAX_RPC_RETRIES = 9;
    private static final Duration INITIAL_RPC_BACKOFF = Duration.standardSeconds((long)1L);
    private static final Duration INITIAL_JOB_STATUS_POLL_BACKOFF = Duration.standardSeconds((long)1L);

    @Override
    public BigQueryServices.JobService getJobService(BigQueryOptions options) {
        return new JobServiceImpl(options);
    }

    @Override
    public BigQueryServices.DatasetService getDatasetService(BigQueryOptions options) {
        return new DatasetServiceImpl(options);
    }

    @Override
    public BigQueryServices.BigQueryJsonReader getReaderFromTable(BigQueryOptions bqOptions, TableReference tableRef) {
        return BigQueryJsonReaderImpl.fromTable(bqOptions, tableRef);
    }

    @Override
    public BigQueryServices.BigQueryJsonReader getReaderFromQuery(BigQueryOptions bqOptions, String query, String projectId, @Nullable Boolean flatten, @Nullable Boolean useLegacySql) {
        return BigQueryJsonReaderImpl.fromQuery(bqOptions, query, projectId, flatten, useLegacySql);
    }

    @VisibleForTesting
    static <T> T executeWithRetries(AbstractGoogleClientRequest<T> request, String errorMessage, Sleeper sleeper, BackOff backoff) throws IOException, InterruptedException {
        IOException lastException = null;
        while (true) {
            try {
                return (T)request.execute();
            }
            catch (IOException e) {
                LOG.warn("Ignore the error and retry the request.", (Throwable)e);
                lastException = e;
                if (BigQueryServicesImpl.nextBackOff(sleeper, backoff)) continue;
                throw new IOException(errorMessage, lastException);
            }
            break;
        }
    }

    private static boolean nextBackOff(Sleeper sleeper, BackOff backoff) throws InterruptedException {
        try {
            return BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BigQueryJsonReaderImpl
    implements BigQueryServices.BigQueryJsonReader {
        private BigQueryTableRowIterator iterator;

        private BigQueryJsonReaderImpl(BigQueryTableRowIterator iterator) {
            this.iterator = iterator;
        }

        private static BigQueryServices.BigQueryJsonReader fromQuery(BigQueryOptions bqOptions, String query, String projectId, @Nullable Boolean flattenResults, @Nullable Boolean useLegacySql) {
            return new BigQueryJsonReaderImpl(BigQueryTableRowIterator.fromQuery(query, projectId, Transport.newBigQueryClient(bqOptions).build(), flattenResults, useLegacySql));
        }

        private static BigQueryServices.BigQueryJsonReader fromTable(BigQueryOptions bqOptions, TableReference tableRef) {
            return new BigQueryJsonReaderImpl(BigQueryTableRowIterator.fromTable(tableRef, Transport.newBigQueryClient(bqOptions).build()));
        }

        @Override
        public boolean start() throws IOException {
            try {
                this.iterator.open();
                return this.iterator.advance();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted during start() operation", e);
            }
        }

        @Override
        public boolean advance() throws IOException {
            try {
                return this.iterator.advance();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted during advance() operation", e);
            }
        }

        @Override
        public TableRow getCurrent() throws NoSuchElementException {
            return this.iterator.getCurrent();
        }

        @Override
        public void close() throws IOException {
            this.iterator.close();
        }
    }

    @VisibleForTesting
    static class DatasetServiceImpl
    implements BigQueryServices.DatasetService {
        private static final long UPLOAD_BATCH_SIZE_BYTES = 65536L;
        private static final long MAX_ROWS_PER_BATCH = 500L;
        private static final FluentBackoff INSERT_BACKOFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)200L)).withMaxRetries(5);
        private static final FluentBackoff DEFAULT_BACKOFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(Duration.standardSeconds((long)1L)).withMaxBackoff(Duration.standardMinutes((long)2L));
        private final ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
        private final Bigquery client;

        @VisibleForTesting
        DatasetServiceImpl(Bigquery client) {
            this.client = client;
        }

        private DatasetServiceImpl(BigQueryOptions bqOptions) {
            this.client = Transport.newBigQueryClient(bqOptions).build();
        }

        @Override
        public Table getTable(String projectId, String datasetId, String tableId) throws IOException, InterruptedException {
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(9).withInitialBackoff(INITIAL_RPC_BACKOFF).backoff();
            return (Table)BigQueryServicesImpl.executeWithRetries(this.client.tables().get(projectId, datasetId, tableId), String.format("Unable to get table: %s, aborting after %d retries.", tableId, 9), Sleeper.DEFAULT, backoff);
        }

        @Override
        public void deleteTable(String projectId, String datasetId, String tableId) throws IOException, InterruptedException {
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(9).withInitialBackoff(INITIAL_RPC_BACKOFF).backoff();
            BigQueryServicesImpl.executeWithRetries(this.client.tables().delete(projectId, datasetId, tableId), String.format("Unable to delete table: %s, aborting after %d retries.", tableId, 9), Sleeper.DEFAULT, backoff);
        }

        public boolean isTableEmpty(String projectId, String datasetId, String tableId) throws IOException, InterruptedException {
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(9).withInitialBackoff(INITIAL_RPC_BACKOFF).backoff();
            TableDataList dataList = (TableDataList)BigQueryServicesImpl.executeWithRetries(this.client.tabledata().list(projectId, datasetId, tableId), String.format("Unable to list table data: %s, aborting after %d retries.", tableId, 9), Sleeper.DEFAULT, backoff);
            return dataList.getRows() == null || dataList.getRows().isEmpty();
        }

        public Dataset getDataset(String projectId, String datasetId) throws IOException, InterruptedException {
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(9).withInitialBackoff(INITIAL_RPC_BACKOFF).backoff();
            return (Dataset)BigQueryServicesImpl.executeWithRetries(this.client.datasets().get(projectId, datasetId), String.format("Unable to get dataset: %s, aborting after %d retries.", datasetId, 9), Sleeper.DEFAULT, backoff);
        }

        @Override
        public void createDataset(String projectId, String datasetId, @Nullable String location, @Nullable String description) throws IOException, InterruptedException {
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(9).withInitialBackoff(INITIAL_RPC_BACKOFF).backoff();
            this.createDataset(projectId, datasetId, location, description, Sleeper.DEFAULT, backoff);
        }

        private void createDataset(String projectId, String datasetId, @Nullable String location, @Nullable String description, Sleeper sleeper, BackOff backoff) throws IOException, InterruptedException {
            Throwable lastException;
            DatasetReference datasetRef = new DatasetReference().setProjectId(projectId).setDatasetId(datasetId);
            Dataset dataset = new Dataset().setDatasetReference(datasetRef);
            if (location != null) {
                dataset.setLocation(location);
            }
            if (description != null) {
                dataset.setFriendlyName(description);
                dataset.setDescription(description);
            }
            do {
                try {
                    this.client.datasets().insert(projectId, dataset).execute();
                    return;
                }
                catch (GoogleJsonResponseException e) {
                    if (this.errorExtractor.itemAlreadyExists((IOException)((Object)e))) {
                        return;
                    }
                    LOG.warn("Ignore the error and retry creating the dataset.", (Throwable)e);
                    lastException = e;
                }
                catch (IOException e) {
                    LOG.warn("Ignore the error and retry creating the dataset.", (Throwable)e);
                    lastException = e;
                }
            } while (BigQueryServicesImpl.nextBackOff(sleeper, backoff));
            throw new IOException(String.format("Unable to create dataset: %s, aborting after %d .", datasetId, 9), lastException);
        }

        @Override
        public void deleteDataset(String projectId, String datasetId) throws IOException, InterruptedException {
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(9).withInitialBackoff(INITIAL_RPC_BACKOFF).backoff();
            BigQueryServicesImpl.executeWithRetries(this.client.datasets().delete(projectId, datasetId), String.format("Unable to delete table: %s, aborting after %d retries.", datasetId, 9), Sleeper.DEFAULT, backoff);
        }
    }

    @VisibleForTesting
    static class JobServiceImpl
    implements BigQueryServices.JobService {
        private final ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
        private final Bigquery client;

        @VisibleForTesting
        JobServiceImpl(Bigquery client) {
            this.client = client;
        }

        private JobServiceImpl(BigQueryOptions options) {
            this.client = Transport.newBigQueryClient(options).build();
        }

        @Override
        public void startLoadJob(JobReference jobRef, JobConfigurationLoad loadConfig) throws InterruptedException, IOException {
            Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setLoad(loadConfig));
            JobServiceImpl.startJob(job, this.errorExtractor, this.client);
        }

        @Override
        public void startExtractJob(JobReference jobRef, JobConfigurationExtract extractConfig) throws InterruptedException, IOException {
            Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setExtract(extractConfig));
            JobServiceImpl.startJob(job, this.errorExtractor, this.client);
        }

        @Override
        public void startQueryJob(JobReference jobRef, JobConfigurationQuery queryConfig) throws IOException, InterruptedException {
            Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setQuery(queryConfig));
            JobServiceImpl.startJob(job, this.errorExtractor, this.client);
        }

        @Override
        public void startCopyJob(JobReference jobRef, JobConfigurationTableCopy copyConfig) throws IOException, InterruptedException {
            Job job = new Job().setJobReference(jobRef).setConfiguration(new JobConfiguration().setCopy(copyConfig));
            JobServiceImpl.startJob(job, this.errorExtractor, this.client);
        }

        private static void startJob(Job job, ApiErrorExtractor errorExtractor, Bigquery client) throws IOException, InterruptedException {
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(9).withInitialBackoff(INITIAL_RPC_BACKOFF).backoff();
            JobServiceImpl.startJob(job, errorExtractor, client, Sleeper.DEFAULT, backoff);
        }

        @VisibleForTesting
        static void startJob(Job job, ApiErrorExtractor errorExtractor, Bigquery client, Sleeper sleeper, BackOff backoff) throws IOException, InterruptedException {
            JobReference jobRef = job.getJobReference();
            Throwable lastException = null;
            do {
                try {
                    client.jobs().insert(jobRef.getProjectId(), job).execute();
                    return;
                }
                catch (GoogleJsonResponseException e) {
                    if (errorExtractor.itemAlreadyExists((IOException)((Object)e))) {
                        return;
                    }
                    LOG.warn("Ignore the error and retry inserting the job.", (Throwable)e);
                    lastException = e;
                }
                catch (IOException e) {
                    LOG.warn("Ignore the error and retry inserting the job.", (Throwable)e);
                    lastException = e;
                }
            } while (BigQueryServicesImpl.nextBackOff(sleeper, backoff));
            throw new IOException(String.format("Unable to insert job: %s, aborting after %d .", jobRef.getJobId(), 9), lastException);
        }

        @Override
        public Job pollJob(JobReference jobRef, int maxAttempts) throws InterruptedException {
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(maxAttempts).withInitialBackoff(INITIAL_JOB_STATUS_POLL_BACKOFF).withMaxBackoff(Duration.standardMinutes((long)1L)).backoff();
            return this.pollJob(jobRef, Sleeper.DEFAULT, backoff);
        }

        @VisibleForTesting
        Job pollJob(JobReference jobRef, Sleeper sleeper, BackOff backoff) throws InterruptedException {
            do {
                try {
                    Job job = (Job)this.client.jobs().get(jobRef.getProjectId(), jobRef.getJobId()).execute();
                    JobStatus status = job.getStatus();
                    if (status != null && status.getState() != null && status.getState().equals("DONE")) {
                        return job;
                    }
                }
                catch (IOException e) {
                    LOG.warn("Ignore the error and retry polling job status.", (Throwable)e);
                }
            } while (BigQueryServicesImpl.nextBackOff(sleeper, backoff));
            LOG.warn("Unable to poll job status: {}, aborting after reached max .", (Object)jobRef.getJobId());
            return null;
        }

        @Override
        public JobStatistics dryRunQuery(String projectId, JobConfigurationQuery queryConfig) throws InterruptedException, IOException {
            Job job = new Job().setConfiguration(new JobConfiguration().setQuery(queryConfig).setDryRun(Boolean.valueOf(true)));
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(9).withInitialBackoff(INITIAL_RPC_BACKOFF).backoff();
            return ((Job)BigQueryServicesImpl.executeWithRetries(this.client.jobs().insert(projectId, job), String.format("Unable to dry run query: %s, aborting after %d retries.", queryConfig, 9), Sleeper.DEFAULT, backoff)).getStatistics();
        }

        @Override
        public Job getJob(JobReference jobRef) throws IOException, InterruptedException {
            BackOff backoff = FluentBackoff.DEFAULT.withMaxRetries(9).withInitialBackoff(INITIAL_JOB_STATUS_POLL_BACKOFF).backoff();
            return this.getJob(jobRef, Sleeper.DEFAULT, backoff);
        }

        @VisibleForTesting
        public Job getJob(JobReference jobRef, Sleeper sleeper, BackOff backoff) throws IOException, InterruptedException {
            Throwable lastException;
            String jobId = jobRef.getJobId();
            do {
                try {
                    return (Job)this.client.jobs().get(jobRef.getProjectId(), jobId).execute();
                }
                catch (GoogleJsonResponseException e) {
                    if (this.errorExtractor.itemNotFound((IOException)((Object)e))) {
                        LOG.info("No BigQuery job with job id {} found.", (Object)jobId);
                        return null;
                    }
                    LOG.warn("Ignoring the error encountered while trying to query the BigQuery job {}", (Object)jobId, (Object)e);
                    lastException = e;
                }
                catch (IOException e) {
                    LOG.warn("Ignoring the error encountered while trying to query the BigQuery job {}", (Object)jobId, (Object)e);
                    lastException = e;
                }
            } while (BigQueryServicesImpl.nextBackOff(sleeper, backoff));
            throw new IOException(String.format("Unable to find BigQuery job: %s, aborting after %d retries.", jobRef, 9), lastException);
        }
    }
}

