/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.dataflow.sdk.io.BigQueryIO;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.util.FluentBackoff;
import com.google.cloud.dataflow.sdk.util.IntervalBoundedExponentialBackOff;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryTableInserter {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryTableInserter.class);
    private static final long UPLOAD_BATCH_SIZE_BYTES = 65536L;
    private static final long MAX_ROWS_PER_BATCH = 500L;
    private static final FluentBackoff INSERT_BACKOFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)200L)).withMaxRetries(5);
    private static final long INITIAL_RATE_LIMIT_EXCEEDED_BACKOFF_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final long MAX_RATE_LIMIT_EXCEEDED_BACKOFF_MS = TimeUnit.MINUTES.toMillis(2L);
    private final Bigquery client;
    private final TableReference defaultRef;
    private final long maxRowsPerBatch;
    private static final ExecutorService executor;
    private static final int RETRY_CREATE_TABLE_DURATION_MILLIS;

    public BigQueryTableInserter(Bigquery client) {
        this.client = client;
        this.defaultRef = null;
        this.maxRowsPerBatch = 500L;
    }

    @Deprecated
    public BigQueryTableInserter(Bigquery client, TableReference defaultRef) {
        this.client = client;
        this.defaultRef = defaultRef;
        this.maxRowsPerBatch = 500L;
    }

    public BigQueryTableInserter(Bigquery client, int maxRowsPerBatch) {
        this.client = client;
        this.defaultRef = null;
        this.maxRowsPerBatch = maxRowsPerBatch;
    }

    @Deprecated
    public BigQueryTableInserter(Bigquery client, TableReference defaultRef, int maxRowsPerBatch) {
        this.client = client;
        this.defaultRef = defaultRef;
        this.maxRowsPerBatch = maxRowsPerBatch;
    }

    @Deprecated
    public void insertAll(List<TableRow> rowList) throws IOException {
        this.insertAll(this.defaultRef, rowList, null, null);
    }

    @Deprecated
    public void insertAll(List<TableRow> rowList, @Nullable List<String> insertIdList) throws IOException {
        this.insertAll(this.defaultRef, rowList, insertIdList, null);
    }

    public void insertAll(TableReference ref, List<TableRow> rowList) throws IOException {
        this.insertAll(ref, rowList, null, null);
    }

    public void insertAll(TableReference ref, List<TableRow> rowList, @Nullable List<String> insertIdList, Aggregator<Long, Long> byteCountAggregator) throws IOException {
        this.insertAll(ref, rowList, insertIdList, byteCountAggregator, INSERT_BACKOFF_FACTORY.backoff(), Sleeper.DEFAULT);
    }

    @VisibleForTesting
    void insertAll(TableReference ref, List<TableRow> rowList, @Nullable List<String> insertIdList, Aggregator<Long, Long> byteCountAggregator, BackOff backoff, final Sleeper sleeper) throws IOException {
        Preconditions.checkNotNull(ref, "ref");
        if (insertIdList != null && rowList.size() != insertIdList.size()) {
            throw new AssertionError((Object)"If insertIdList is not null it needs to have at least as many elements as rowList");
        }
        ArrayList<TableDataInsertAllResponse.InsertErrors> allErrors = new ArrayList<TableDataInsertAllResponse.InsertErrors>();
        List<TableRow> rowsToPublish = rowList;
        List<String> idsToPublish = insertIdList;
        while (true) {
            long nextBackoffMillis;
            int i;
            ArrayList<TableRow> retryRows = new ArrayList<TableRow>();
            ArrayList<String> retryIds = idsToPublish != null ? new ArrayList<String>() : null;
            int strideIndex = 0;
            LinkedList<TableDataInsertAllRequest.Rows> rows = new LinkedList<TableDataInsertAllRequest.Rows>();
            int dataSize = 0;
            ArrayList<Future<List<TableDataInsertAllResponse.InsertErrors>>> futures = new ArrayList<Future<List<TableDataInsertAllResponse.InsertErrors>>>();
            ArrayList<Integer> strideIndices = new ArrayList<Integer>();
            for (i = 0; i < rowsToPublish.size(); ++i) {
                TableRow row = rowsToPublish.get(i);
                TableDataInsertAllRequest.Rows out = new TableDataInsertAllRequest.Rows();
                if (idsToPublish != null) {
                    out.setInsertId(idsToPublish.get(i));
                }
                out.setJson(row.getUnknownKeys());
                rows.add(out);
                if ((long)(dataSize += row.toString().length()) < 65536L && (long)rows.size() < this.maxRowsPerBatch && i != rowsToPublish.size() - 1) continue;
                TableDataInsertAllRequest content = new TableDataInsertAllRequest();
                content.setRows(rows);
                final Bigquery.Tabledata.InsertAll insert = this.client.tabledata().insertAll(ref.getProjectId(), ref.getDatasetId(), ref.getTableId(), content);
                futures.add(executor.submit(new Callable<List<TableDataInsertAllResponse.InsertErrors>>(){

                    @Override
                    public List<TableDataInsertAllResponse.InsertErrors> call() throws IOException {
                        IntervalBoundedExponentialBackOff backoff = new IntervalBoundedExponentialBackOff(MAX_RATE_LIMIT_EXCEEDED_BACKOFF_MS, INITIAL_RATE_LIMIT_EXCEEDED_BACKOFF_MS);
                        while (true) {
                            try {
                                return ((TableDataInsertAllResponse)insert.execute()).getInsertErrors();
                            }
                            catch (IOException e) {
                                if (new ApiErrorExtractor().rateLimited((Throwable)e)) {
                                    LOG.info("BigQuery insertAll exceeded rate limit, retrying");
                                    try {
                                        sleeper.sleep(backoff.nextBackOffMillis());
                                    }
                                    catch (InterruptedException interrupted) {
                                        Thread.currentThread().interrupt();
                                        throw new IOException("Interrupted while waiting before retrying insertAll");
                                    }
                                    continue;
                                }
                                throw e;
                            }
                            break;
                        }
                    }
                }));
                strideIndices.add(strideIndex);
                if (byteCountAggregator != null) {
                    byteCountAggregator.addValue(Long.valueOf(dataSize));
                }
                dataSize = 0;
                strideIndex = i + 1;
                rows = new LinkedList();
            }
            try {
                for (i = 0; i < futures.size(); ++i) {
                    List errors = (List)((Future)futures.get(i)).get();
                    if (errors == null) continue;
                    for (TableDataInsertAllResponse.InsertErrors error : errors) {
                        allErrors.add(error);
                        if (error.getIndex() == null) {
                            throw new IOException("Insert failed: " + allErrors);
                        }
                        int errorIndex = error.getIndex().intValue() + (Integer)strideIndices.get(i);
                        retryRows.add(rowsToPublish.get(errorIndex));
                        if (retryIds == null) continue;
                        retryIds.add(idsToPublish.get(errorIndex));
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while inserting " + rowsToPublish);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            if (allErrors.isEmpty() || (nextBackoffMillis = backoff.nextBackOffMillis()) == -1L) break;
            try {
                sleeper.sleep(nextBackoffMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while waiting before retrying insert of " + retryRows);
            }
            rowsToPublish = retryRows;
            idsToPublish = retryIds;
            allErrors.clear();
            LOG.info("Retrying {} failed inserts to BigQuery", (Object)rowsToPublish.size());
        }
        if (!allErrors.isEmpty()) {
            throw new IOException("Insert failed: " + allErrors);
        }
    }

    public Table getOrCreateTable(TableReference ref, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, @Nullable TableSchema schema) throws IOException {
        Table table;
        block9: {
            Bigquery.Tables.Get get = this.client.tables().get(ref.getProjectId(), ref.getDatasetId(), ref.getTableId());
            table = null;
            try {
                table = (Table)get.execute();
            }
            catch (IOException e) {
                ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
                if (errorExtractor.itemNotFound(e) && createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED) break block9;
                throw e;
            }
        }
        if (table != null) {
            if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_APPEND) {
                return table;
            }
            boolean empty = this.isEmpty(ref);
            if (empty) {
                if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE) {
                    LOG.info("Empty table found, not removing {}", (Object)BigQueryIO.toTableSpec(ref));
                }
                return table;
            }
            if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_EMPTY) {
                throw new IOException("WriteDisposition is WRITE_EMPTY, but table is not empty");
            }
            if (schema == null) {
                schema = table.getSchema();
            }
            LOG.info("Deleting table {}", (Object)BigQueryIO.toTableSpec(ref));
            Bigquery.Tables.Delete delete = this.client.tables().delete(ref.getProjectId(), ref.getDatasetId(), ref.getTableId());
            delete.execute();
        }
        if (schema == null) {
            throw new IllegalArgumentException("Table schema required for new table.");
        }
        return this.tryCreateTable(ref, schema);
    }

    public boolean isEmpty(TableReference ref) throws IOException {
        Bigquery.Tabledata.List list = this.client.tabledata().list(ref.getProjectId(), ref.getDatasetId(), ref.getTableId());
        list.setMaxResults(Long.valueOf(1L));
        TableDataList dataList = (TableDataList)list.execute();
        return dataList.getRows() == null || dataList.getRows().isEmpty();
    }

    @Nullable
    public Table tryCreateTable(TableReference ref, TableSchema schema) throws IOException {
        LOG.info("Trying to create BigQuery table: {}", (Object)BigQueryIO.toTableSpec(ref));
        ExponentialBackOff backoff = new ExponentialBackOff.Builder().setMaxElapsedTimeMillis(RETRY_CREATE_TABLE_DURATION_MILLIS).build();
        Table table = new Table().setTableReference(ref).setSchema(schema);
        return this.tryCreateTable(table, ref.getProjectId(), ref.getDatasetId(), (BackOff)backoff, Sleeper.DEFAULT);
    }

    @Nullable
    @VisibleForTesting
    Table tryCreateTable(Table table, String projectId, String datasetId, BackOff backoff, Sleeper sleeper) throws IOException {
        boolean retry = false;
        while (true) {
            try {
                return (Table)this.client.tables().insert(projectId, datasetId, table).execute();
            }
            catch (IOException e) {
                block8: {
                    ApiErrorExtractor extractor = new ApiErrorExtractor();
                    if (extractor.itemAlreadyExists(e)) {
                        return null;
                    }
                    if (extractor.rateLimited((Throwable)e)) {
                        try {
                            if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) {
                                if (retry) continue;
                                LOG.info("Quota limit reached when creating table {}:{}.{}, retrying up to {} minutes", new Object[]{projectId, datasetId, table.getTableReference().getTableId(), (double)TimeUnit.MILLISECONDS.toSeconds(RETRY_CREATE_TABLE_DURATION_MILLIS) / 60.0});
                                retry = true;
                                continue;
                            }
                            break block8;
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                        continue;
                    }
                }
                throw e;
            }
            break;
        }
    }

    static {
        ThreadPoolExecutor tempExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(100);
        tempExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        executor = MoreExecutors.getExitingExecutorService(tempExecutor, 10L, TimeUnit.SECONDS);
        RETRY_CREATE_TABLE_DURATION_MILLIS = (int)TimeUnit.MINUTES.toMillis(5L);
    }
}

