/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import java.util.HashMap;
import java.util.Map;

public class BucketingFunction {
    private final long bucketWidthMs;
    private final int numSignificantBuckets;
    private final int numSignificantSamples;
    private final Combine.BinaryCombineLongFn function;
    private final Map<Long, Bucket> buckets;

    public BucketingFunction(long bucketWidthMs, int numSignificantBuckets, int numSignificantSamples, Combine.BinaryCombineLongFn function) {
        this.bucketWidthMs = bucketWidthMs;
        this.numSignificantBuckets = numSignificantBuckets;
        this.numSignificantSamples = numSignificantSamples;
        this.function = function;
        this.buckets = new HashMap<Long, Bucket>();
    }

    private long key(long timeMsSinceEpoch) {
        return timeMsSinceEpoch - timeMsSinceEpoch % this.bucketWidthMs;
    }

    public void add(long timeMsSinceEpoch, long value) {
        long key = this.key(timeMsSinceEpoch);
        Bucket bucket = this.buckets.get(key);
        if (bucket == null) {
            bucket = new Bucket(this);
            this.buckets.put(key, bucket);
        }
        bucket.add(this, value);
    }

    public void remove(long timeMsSinceEpoch) {
        long key = this.key(timeMsSinceEpoch);
        Bucket bucket = this.buckets.get(key);
        if (bucket == null) {
            return;
        }
        if (bucket.remove()) {
            this.buckets.remove(key);
        }
    }

    public long get() {
        long result = this.function.identity();
        for (Bucket bucket : this.buckets.values()) {
            result = this.function.apply(result, bucket.get());
        }
        return result;
    }

    public boolean isSignificant() {
        if (this.buckets.size() >= this.numSignificantBuckets) {
            return true;
        }
        int totalSamples = 0;
        for (Bucket bucket : this.buckets.values()) {
            totalSamples += bucket.numSamples;
        }
        return totalSamples >= this.numSignificantSamples;
    }

    private static class Bucket {
        private int numSamples = 0;
        private long combinedValue;

        public Bucket(BucketingFunction outer) {
            this.combinedValue = outer.function.identity();
        }

        public void add(BucketingFunction outer, long value) {
            this.combinedValue = outer.function.apply(this.combinedValue, value);
            ++this.numSamples;
        }

        public boolean remove() {
            --this.numSamples;
            Preconditions.checkState(this.numSamples >= 0, "Lost count of samples");
            return this.numSamples == 0;
        }

        public long get() {
            return this.combinedValue;
        }
    }
}

