/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.api.client.util.Base64;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.coders.KvCoderBase;
import com.google.cloud.dataflow.sdk.coders.MapCoder;
import com.google.cloud.dataflow.sdk.coders.MapCoderBase;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Throwables;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.ExposedByteArrayInputStream;
import com.google.cloud.dataflow.sdk.util.ExposedByteArrayOutputStream;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.UnownedInputStream;
import com.google.cloud.dataflow.sdk.util.UnownedOutputStream;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.Map;

public final class CoderUtils {
    public static final String KIND_PAIR = "kind:pair";
    public static final String KIND_STREAM = "kind:stream";
    private static ThreadLocal<SoftReference<ExposedByteArrayOutputStream>> threadLocalOutputStream = new ThreadLocal();
    private static ThreadLocal<Boolean> threadLocalOutputStreamInUse = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    private CoderUtils() {
    }

    public static <T> byte[] encodeToByteArray(Coder<T> coder, T value) throws CoderException {
        return CoderUtils.encodeToByteArray(coder, value, Coder.Context.OUTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> byte[] encodeToByteArray(Coder<T> coder, T value, Coder.Context context) throws CoderException {
        if (threadLocalOutputStreamInUse.get().booleanValue()) {
            ExposedByteArrayOutputStream stream = new ExposedByteArrayOutputStream();
            CoderUtils.encodeToSafeStream(coder, value, stream, context);
            return ((ByteArrayOutputStream)stream).toByteArray();
        }
        threadLocalOutputStreamInUse.set(true);
        try {
            ByteArrayOutputStream stream = CoderUtils.getThreadLocalOutputStream();
            CoderUtils.encodeToSafeStream(coder, value, stream, context);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        finally {
            threadLocalOutputStreamInUse.set(false);
        }
    }

    private static <T> void encodeToSafeStream(Coder<T> coder, T value, OutputStream stream, Coder.Context context) throws CoderException {
        try {
            coder.encode(value, new UnownedOutputStream(stream), context);
        }
        catch (IOException exn) {
            Throwables.propagateIfPossible(exn, CoderException.class);
            throw new IllegalArgumentException("Forbidden IOException when writing to OutputStream", exn);
        }
    }

    public static <T> T decodeFromByteArray(Coder<T> coder, byte[] encodedValue) throws CoderException {
        return CoderUtils.decodeFromByteArray(coder, encodedValue, Coder.Context.OUTER);
    }

    public static <T> T decodeFromByteArray(Coder<T> coder, byte[] encodedValue, Coder.Context context) throws CoderException {
        try (ExposedByteArrayInputStream stream = new ExposedByteArrayInputStream(encodedValue);){
            T result = CoderUtils.decodeFromSafeStream(coder, stream, context);
            if (stream.available() != 0) {
                throw new CoderException(stream.available() + " unexpected extra bytes after decoding " + result);
            }
            T t = result;
            return t;
        }
    }

    private static <T> T decodeFromSafeStream(Coder<T> coder, InputStream stream, Coder.Context context) throws CoderException {
        try {
            return coder.decode(new UnownedInputStream(stream), context);
        }
        catch (IOException exn) {
            Throwables.propagateIfPossible(exn, CoderException.class);
            throw new IllegalArgumentException("Forbidden IOException when reading from InputStream", exn);
        }
    }

    private static ByteArrayOutputStream getThreadLocalOutputStream() {
        ExposedByteArrayOutputStream stream;
        SoftReference<ExposedByteArrayOutputStream> refStream = threadLocalOutputStream.get();
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = stream = refStream == null ? null : refStream.get();
        if (stream == null) {
            stream = new ExposedByteArrayOutputStream();
            threadLocalOutputStream.set(new SoftReference<ExposedByteArrayOutputStream>(stream));
        }
        stream.reset();
        return stream;
    }

    public static <T> T clone(Coder<T> coder, T value) throws CoderException {
        return CoderUtils.decodeFromByteArray(coder, CoderUtils.encodeToByteArray(coder, value, Coder.Context.OUTER));
    }

    public static <T> String encodeToBase64(Coder<T> coder, T value) throws CoderException {
        byte[] rawValue = CoderUtils.encodeToByteArray(coder, value);
        return Base64.encodeBase64URLSafeString((byte[])rawValue);
    }

    public static <T> T decodeFromBase64(Coder<T> coder, String encodedValue) throws CoderException {
        return CoderUtils.decodeFromSafeStream(coder, new ByteArrayInputStream(Base64.decodeBase64((String)encodedValue)), Coder.Context.OUTER);
    }

    public static TypeDescriptor getCodedType(TypeDescriptor coderDescriptor) {
        ParameterizedType coderType = (ParameterizedType)coderDescriptor.getSupertype(Coder.class).getType();
        TypeDescriptor<?> codedType = TypeDescriptor.of(coderType.getActualTypeArguments()[0]);
        return codedType;
    }

    public static CloudObject makeCloudEncoding(String type, CloudObject ... componentSpecs) {
        CloudObject encoding = CloudObject.forClassName(type);
        if (componentSpecs.length > 0) {
            Structs.addList((Map)((Object)encoding), (String)"component_encodings", (Map[])componentSpecs);
        }
        return encoding;
    }

    static final class Jackson2Module
    extends SimpleModule {
        public Jackson2Module() {
            super("DataflowCoders");
            this.setMixInAnnotation(Coder.class, Mixin.class);
        }

        @JsonTypeIdResolver(value=Resolver.class)
        @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="@type")
        private static final class Mixin {
            private Mixin() {
            }
        }

        private static final class Resolver
        extends TypeIdResolverBase {
            public Resolver() {
                super(TypeFactory.defaultInstance().constructType(Coder.class), TypeFactory.defaultInstance());
            }

            @Deprecated
            public JavaType typeFromId(String id) {
                return this.typeFromId(null, id);
            }

            public JavaType typeFromId(DatabindContext context, String id) {
                Class<Object> clazz = this.getClassForId(id);
                if (clazz == KvCoder.class) {
                    clazz = KvCoderBase.class;
                }
                if (clazz == MapCoder.class) {
                    clazz = MapCoderBase.class;
                }
                TypeVariable<Class<Object>>[] tvs = clazz.getTypeParameters();
                JavaType[] types = new JavaType[tvs.length];
                for (int lupe = 0; lupe < tvs.length; ++lupe) {
                    types[lupe] = TypeFactory.unknownType();
                }
                return this._typeFactory.constructSimpleType(clazz, types);
            }

            private Class<?> getClassForId(String id) {
                try {
                    if (id.contains(".")) {
                        return Class.forName(id);
                    }
                    if (id.equals(CoderUtils.KIND_STREAM)) {
                        return IterableCoder.class;
                    }
                    if (id.equals(CoderUtils.KIND_PAIR)) {
                        return KvCoder.class;
                    }
                    return Class.forName(Coder.class.getPackage().getName() + "." + id);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to convert coder ID " + id + " to class", e);
                }
            }

            public String idFromValueAndType(Object o, Class<?> clazz) {
                return clazz.getName();
            }

            public String idFromValue(Object o) {
                return o.getClass().getName();
            }

            public JsonTypeInfo.Id getMechanism() {
                return JsonTypeInfo.Id.CUSTOM;
            }
        }
    }
}

