/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AbstractPromptReceiver;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.cloud.dataflow.sdk.options.GcpOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.Transport;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Credentials {
    private static final Logger LOG = LoggerFactory.getLogger(Credentials.class);
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/cloud-platform", "https://www.googleapis.com/auth/devstorage.full_control", "https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/datastore");

    public static Credential getCredential(GcpOptions options) throws IOException, GeneralSecurityException {
        String keyFile = options.getServiceAccountKeyfile();
        String accountName = options.getServiceAccountName();
        if (keyFile != null && accountName != null) {
            try {
                return Credentials.getCredentialFromFile(keyFile, accountName, SCOPES);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Unable to obtain credentials from file", e);
            }
        }
        if (options.getSecretsFile() != null) {
            return Credentials.getCredentialFromClientSecrets(options, SCOPES);
        }
        try {
            return GoogleCredential.getApplicationDefault().createScoped(SCOPES);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get application default credentials. Please see https://developers.google.com/accounts/docs/application-default-credentials for details on how to specify credentials. This version of the SDK is dependent on the gcloud core component version 2015.02.05 or newer to be able to get credentials from the currently authorized user via gcloud auth.", e);
        }
    }

    private static Credential getCredentialFromFile(String keyFile, String accountId, Collection<String> scopes) throws IOException, GeneralSecurityException {
        GoogleCredential credential = new GoogleCredential.Builder().setTransport(Transport.getTransport()).setJsonFactory(Transport.getJsonFactory()).setServiceAccountId(accountId).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(new File(keyFile)).build();
        LOG.info("Created credential from file {}", (Object)keyFile);
        return credential;
    }

    private static Credential getCredentialFromClientSecrets(GcpOptions options, Collection<String> scopes) throws IOException, GeneralSecurityException {
        GoogleClientSecrets clientSecrets;
        String clientSecretsFile = options.getSecretsFile();
        Preconditions.checkArgument(clientSecretsFile != null);
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        try {
            clientSecrets = GoogleClientSecrets.load((JsonFactory)jsonFactory, (Reader)new FileReader(clientSecretsFile));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read the client secrets from file: " + clientSecretsFile, e);
        }
        FileDataStoreFactory dataStoreFactory = new FileDataStoreFactory(new File(options.getCredentialDir()));
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, clientSecrets, scopes).setDataStoreFactory((DataStoreFactory)dataStoreFactory).setTokenServerUrl(new GenericUrl(options.getTokenServerUrl())).setAuthorizationServerEncodedUrl(options.getAuthorizationServerEncodedUrl()).build();
        Credential credential = new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)new PromptReceiver()).authorize(options.getCredentialId());
        LOG.info("Got credential from client secret");
        return credential;
    }

    private static class PromptReceiver
    extends AbstractPromptReceiver {
        private PromptReceiver() {
        }

        public String getRedirectUri() {
            return "urn:ietf:wg:oauth:2.0:oob";
        }
    }
}

