/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.util.BaseExecutionContext;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import com.google.cloud.dataflow.sdk.util.state.InMemoryStateInternals;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import java.util.List;
import java.util.Map;

public class DirectModeExecutionContext
extends BaseExecutionContext<StepContext> {
    private Object key;
    private List<DirectPipelineRunner.ValueWithMetadata<?>> output = Lists.newArrayList();
    private Map<TupleTag<?>, List<DirectPipelineRunner.ValueWithMetadata<?>>> sideOutputs = Maps.newHashMap();

    protected DirectModeExecutionContext() {
    }

    public static DirectModeExecutionContext create() {
        return new DirectModeExecutionContext();
    }

    @Override
    protected StepContext createStepContext(String stepName, String transformName, StateSampler stateSampler) {
        return new StepContext(this, stepName, transformName);
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object newKey) {
        for (ExecutionContext.StepContext stepContext : this.getAllStepContexts()) {
            ((StepContext)stepContext).switchKey(newKey);
        }
        this.key = newKey;
    }

    @Override
    public void noteOutput(WindowedValue<?> outputElem) {
        this.output.add(DirectPipelineRunner.ValueWithMetadata.of(outputElem).withKey(this.getKey()));
    }

    @Override
    public void noteSideOutput(TupleTag<?> tag, WindowedValue<?> outputElem) {
        List<DirectPipelineRunner.ValueWithMetadata<?>> output = this.sideOutputs.get(tag);
        if (output == null) {
            output = Lists.newArrayList();
            this.sideOutputs.put(tag, output);
        }
        output.add(DirectPipelineRunner.ValueWithMetadata.of(outputElem).withKey(this.getKey()));
    }

    public <T> List<DirectPipelineRunner.ValueWithMetadata<T>> getOutput(TupleTag<T> tag) {
        List<DirectPipelineRunner.ValueWithMetadata<T>> typedOutput = this.output;
        return typedOutput;
    }

    public <T> List<DirectPipelineRunner.ValueWithMetadata<T>> getSideOutput(TupleTag<T> tag) {
        if (this.sideOutputs.containsKey(tag)) {
            List<DirectPipelineRunner.ValueWithMetadata<T>> typedOutput = this.sideOutputs.get(tag);
            return typedOutput;
        }
        return Lists.newArrayList();
    }

    public static class StepContext
    extends BaseExecutionContext.StepContext {
        private final Map<Object, InMemoryStateInternals<Object>> stateInternals = Maps.newHashMap();
        private InMemoryStateInternals<Object> currentStateInternals = null;

        private StepContext(ExecutionContext executionContext, String stepName, String transformName) {
            super(executionContext, stepName, transformName);
            this.switchKey(null);
        }

        public void switchKey(Object newKey) {
            this.currentStateInternals = this.stateInternals.get(newKey);
            if (this.currentStateInternals == null) {
                this.currentStateInternals = InMemoryStateInternals.forKey(newKey);
                this.stateInternals.put(newKey, this.currentStateInternals);
            }
        }

        public StateInternals<Object> stateInternals() {
            return Preconditions.checkNotNull(this.currentStateInternals);
        }

        @Override
        public TimerInternals timerInternals() {
            throw new UnsupportedOperationException("Direct mode cannot return timerInternals");
        }
    }
}

