/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import com.google.cloud.dataflow.sdk.util.FinishedTriggers;
import java.util.BitSet;

public class FinishedTriggersBitSet
implements FinishedTriggers {
    private final BitSet bitSet;

    private FinishedTriggersBitSet(BitSet bitSet) {
        this.bitSet = bitSet;
    }

    public static FinishedTriggersBitSet emptyWithCapacity(int capacity) {
        return new FinishedTriggersBitSet(new BitSet(capacity));
    }

    public static FinishedTriggersBitSet fromBitSet(BitSet bitSet) {
        return new FinishedTriggersBitSet(bitSet);
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    @Override
    public boolean isFinished(ExecutableTrigger<?> trigger) {
        return this.bitSet.get(trigger.getTriggerIndex());
    }

    @Override
    public void setFinished(ExecutableTrigger<?> trigger, boolean value) {
        this.bitSet.set(trigger.getTriggerIndex(), value);
    }

    @Override
    public void clearRecursively(ExecutableTrigger<?> trigger) {
        this.bitSet.clear(trigger.getTriggerIndex(), trigger.getFirstIndexAfterSubtree());
    }

    @Override
    public FinishedTriggersBitSet copy() {
        return new FinishedTriggersBitSet((BitSet)this.bitSet.clone());
    }
}

