/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Sets;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import com.google.cloud.dataflow.sdk.util.FinishedTriggers;
import java.util.Set;

public class FinishedTriggersSet
implements FinishedTriggers {
    private final Set<ExecutableTrigger<?>> finishedTriggers;

    private FinishedTriggersSet(Set<ExecutableTrigger<?>> finishedTriggers) {
        this.finishedTriggers = finishedTriggers;
    }

    public static FinishedTriggersSet fromSet(Set<ExecutableTrigger<?>> finishedTriggers) {
        return new FinishedTriggersSet(finishedTriggers);
    }

    public Set<ExecutableTrigger<?>> getFinishedTriggers() {
        return this.finishedTriggers;
    }

    @Override
    public boolean isFinished(ExecutableTrigger<?> trigger) {
        return this.finishedTriggers.contains(trigger);
    }

    @Override
    public void setFinished(ExecutableTrigger<?> trigger, boolean value) {
        if (value) {
            this.finishedTriggers.add(trigger);
        } else {
            this.finishedTriggers.remove(trigger);
        }
    }

    @Override
    public void clearRecursively(ExecutableTrigger<?> trigger) {
        this.finishedTriggers.remove(trigger);
        for (ExecutableTrigger<?> subTrigger : trigger.subTriggers()) {
            this.clearRecursively(subTrigger);
        }
    }

    @Override
    public FinishedTriggersSet copy() {
        return FinishedTriggersSet.fromSet(Sets.newHashSet(this.finishedTriggers));
    }
}

