/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.Sum;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.GroupAlsoByWindowsViaOutputBufferDoFn;
import com.google.cloud.dataflow.sdk.util.SystemDoFnInternal;
import com.google.cloud.dataflow.sdk.util.SystemReduceFn;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.KV;

@SystemDoFnInternal
public abstract class GroupAlsoByWindowsDoFn<K, InputT, OutputT, W extends BoundedWindow>
extends DoFn<KV<K, Iterable<WindowedValue<InputT>>>, KV<K, OutputT>> {
    public static final String DROPPED_DUE_TO_CLOSED_WINDOW_COUNTER = "DroppedDueToClosedWindow";
    public static final String DROPPED_DUE_TO_LATENESS_COUNTER = "DroppedDueToLateness";
    protected final Aggregator<Long, Long> droppedDueToClosedWindow = this.createAggregator("DroppedDueToClosedWindow", new Sum.SumLongFn());
    protected final Aggregator<Long, Long> droppedDueToLateness = this.createAggregator("DroppedDueToLateness", new Sum.SumLongFn());

    public static <K, V, W extends BoundedWindow> GroupAlsoByWindowsDoFn<K, V, Iterable<V>, W> createDefault(WindowingStrategy<?, W> windowingStrategy, Coder<V> inputCoder) {
        return new GroupAlsoByWindowsViaOutputBufferDoFn(windowingStrategy, SystemReduceFn.buffering(inputCoder));
    }
}

