/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.KeyedWorkItem;
import com.google.cloud.dataflow.sdk.util.KeyedWorkItems;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class KeyedWorkItemCoder<K, ElemT>
extends StandardCoder<KeyedWorkItem<K, ElemT>> {
    private final Coder<K> keyCoder;
    private final Coder<ElemT> elemCoder;
    private final Coder<? extends BoundedWindow> windowCoder;
    private final Coder<Iterable<TimerInternals.TimerData>> timersCoder;
    private final Coder<Iterable<WindowedValue<ElemT>>> elemsCoder;

    public static <K, ElemT> KeyedWorkItemCoder<K, ElemT> of(Coder<K> keyCoder, Coder<ElemT> elemCoder, Coder<? extends BoundedWindow> windowCoder) {
        return new KeyedWorkItemCoder<K, ElemT>(keyCoder, elemCoder, windowCoder);
    }

    @JsonCreator
    public static <K, ElemT> KeyedWorkItemCoder<K, ElemT> of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
        Preconditions.checkArgument(components.size() == 3, "Expecting 3 components, got %s", components.size());
        Coder<?> keyCoder = components.get(0);
        Coder<?> elemCoder = components.get(1);
        Coder<?> windowCoder = components.get(2);
        return new KeyedWorkItemCoder(keyCoder, elemCoder, windowCoder);
    }

    private KeyedWorkItemCoder(Coder<K> keyCoder, Coder<ElemT> elemCoder, Coder<? extends BoundedWindow> windowCoder) {
        this.keyCoder = keyCoder;
        this.elemCoder = elemCoder;
        this.windowCoder = windowCoder;
        this.timersCoder = IterableCoder.of(TimerInternals.TimerDataCoder.of(windowCoder));
        this.elemsCoder = IterableCoder.of(WindowedValue.FullWindowedValueCoder.of(elemCoder, windowCoder));
    }

    @Override
    public void encode(KeyedWorkItem<K, ElemT> value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        Coder.Context nestedContext = context.nested();
        this.keyCoder.encode(value.key(), outStream, nestedContext);
        this.timersCoder.encode(value.timersIterable(), outStream, nestedContext);
        this.elemsCoder.encode(value.elementsIterable(), outStream, nestedContext);
    }

    @Override
    public KeyedWorkItem<K, ElemT> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        Coder.Context nestedContext = context.nested();
        K key = this.keyCoder.decode(inStream, nestedContext);
        Iterable<TimerInternals.TimerData> timers = this.timersCoder.decode(inStream, nestedContext);
        Iterable<WindowedValue<ElemT>> elems = this.elemsCoder.decode(inStream, nestedContext);
        return KeyedWorkItems.workItem(key, timers, elems);
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return ImmutableList.of(this.keyCoder, this.elemCoder, this.windowCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.keyCoder.verifyDeterministic();
        this.timersCoder.verifyDeterministic();
        this.elemsCoder.verifyDeterministic();
    }

    @Override
    public boolean consistentWithEquals() {
        return false;
    }
}

