/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.MapCoder;
import com.google.cloud.dataflow.sdk.coders.SetCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Sets;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import com.google.cloud.dataflow.sdk.util.ActiveWindowSet;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.util.state.StateNamespaces;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class MergingActiveWindowSet<W extends BoundedWindow>
implements ActiveWindowSet<W> {
    private final WindowFn<Object, W> windowFn;
    private final Map<W, Set<W>> activeWindowToStateAddressWindows;
    private final Map<W, Set<W>> originalActiveWindowToStateAddressWindows;
    private final ValueState<Map<W, Set<W>>> valueState;

    public MergingActiveWindowSet(WindowFn<Object, W> windowFn, StateInternals<?> state) {
        this.windowFn = windowFn;
        StateTag tag = StateTags.makeSystemTagInternal(StateTags.value("tree", MapCoder.of(windowFn.windowCoder(), SetCoder.of(windowFn.windowCoder()))));
        this.valueState = state.state(StateNamespaces.global(), tag);
        this.activeWindowToStateAddressWindows = MergingActiveWindowSet.emptyIfNull((Map)this.valueState.read());
        this.originalActiveWindowToStateAddressWindows = MergingActiveWindowSet.deepCopy(this.activeWindowToStateAddressWindows);
    }

    @Override
    public void cleanupTemporaryWindows() {
        Iterator<Map.Entry<W, Set<W>>> iter = this.activeWindowToStateAddressWindows.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<W, Set<W>> entry = iter.next();
            if (!entry.getValue().isEmpty()) continue;
            iter.remove();
        }
    }

    @Override
    public void persist() {
        this.checkInvariants();
        if (this.activeWindowToStateAddressWindows.isEmpty()) {
            this.valueState.clear();
            return;
        }
        if (this.activeWindowToStateAddressWindows.equals(this.originalActiveWindowToStateAddressWindows)) {
            return;
        }
        this.valueState.write(this.activeWindowToStateAddressWindows);
    }

    @Override
    public Set<W> getActiveAndNewWindows() {
        return this.activeWindowToStateAddressWindows.keySet();
    }

    @Override
    public boolean isActive(W window) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(window);
        return stateAddressWindows != null && !stateAddressWindows.isEmpty();
    }

    @Override
    public boolean isActiveOrNew(W window) {
        return this.activeWindowToStateAddressWindows.containsKey(window);
    }

    @Override
    public void ensureWindowExists(W window) {
        if (!this.activeWindowToStateAddressWindows.containsKey(window)) {
            this.activeWindowToStateAddressWindows.put(window, new LinkedHashSet());
        }
    }

    @Override
    public void ensureWindowIsActive(W window) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(window);
        Preconditions.checkState(stateAddressWindows != null, "Cannot ensure window %s is active since it is neither ACTIVE nor NEW", window);
        if (stateAddressWindows.isEmpty()) {
            stateAddressWindows.add(window);
        }
    }

    @Override
    @VisibleForTesting
    public void addActiveForTesting(W window) {
        if (!this.activeWindowToStateAddressWindows.containsKey(window)) {
            LinkedHashSet<W> stateAddressWindows = new LinkedHashSet<W>();
            stateAddressWindows.add(window);
            this.activeWindowToStateAddressWindows.put(window, stateAddressWindows);
        }
    }

    @VisibleForTesting
    public void addActiveForTesting(W window, Iterable<W> stateAddressWindows) {
        if (!this.activeWindowToStateAddressWindows.containsKey(window)) {
            this.activeWindowToStateAddressWindows.put(window, Sets.newLinkedHashSet(stateAddressWindows));
        }
    }

    @Override
    public void remove(W window) {
        this.activeWindowToStateAddressWindows.remove(window);
    }

    @Override
    public void merge(ActiveWindowSet.MergeCallback<W> mergeCallback) throws Exception {
        MergeContextImpl context = new MergeContextImpl(mergeCallback);
        this.windowFn.mergeWindows(context);
        context.recordMerges();
    }

    private void recordMerge(Collection<W> toBeMerged, W mergeResult) throws Exception {
        LinkedHashSet<Object> newStateAddressWindows = new LinkedHashSet<Object>();
        Set<W> existingStateAddressWindows = this.activeWindowToStateAddressWindows.get(mergeResult);
        if (existingStateAddressWindows != null) {
            newStateAddressWindows.addAll(existingStateAddressWindows);
        }
        for (BoundedWindow other : toBeMerged) {
            Set<W> otherStateAddressWindows = this.activeWindowToStateAddressWindows.get(other);
            Preconditions.checkState(otherStateAddressWindows != null, "Window %s is not ACTIVE or NEW", other);
            for (BoundedWindow otherStateAddressWindow : otherStateAddressWindows) {
                newStateAddressWindows.add(otherStateAddressWindow);
            }
            this.activeWindowToStateAddressWindows.remove(other);
        }
        if (newStateAddressWindows.isEmpty()) {
            newStateAddressWindows.add(mergeResult);
        }
        this.activeWindowToStateAddressWindows.put(mergeResult, newStateAddressWindows);
        this.merged(mergeResult);
    }

    @Override
    public void merged(W window) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(window);
        Preconditions.checkState(stateAddressWindows != null, "Window %s is not ACTIVE", window);
        BoundedWindow first = Iterables.getFirst(stateAddressWindows, null);
        stateAddressWindows.clear();
        stateAddressWindows.add(first);
    }

    @Override
    public Set<W> readStateAddresses(W window) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(window);
        Preconditions.checkState(stateAddressWindows != null, "Window %s is not ACTIVE", window);
        return stateAddressWindows;
    }

    @Override
    public W writeStateAddress(W window) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(window);
        Preconditions.checkState(stateAddressWindows != null, "Window %s is not ACTIVE", window);
        BoundedWindow result = Iterables.getFirst(stateAddressWindows, null);
        Preconditions.checkState(result != null, "Window %s is still NEW", window);
        return (W)result;
    }

    @Override
    public W mergedWriteStateAddress(Collection<W> toBeMerged, W mergeResult) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(mergeResult);
        if (stateAddressWindows != null && !stateAddressWindows.isEmpty()) {
            return (W)((BoundedWindow)Iterables.getFirst(stateAddressWindows, null));
        }
        for (BoundedWindow mergedWindow : toBeMerged) {
            stateAddressWindows = this.activeWindowToStateAddressWindows.get(mergedWindow);
            if (stateAddressWindows == null || stateAddressWindows.isEmpty()) continue;
            return (W)((BoundedWindow)Iterables.getFirst(stateAddressWindows, null));
        }
        return mergeResult;
    }

    @VisibleForTesting
    public void checkInvariants() {
        HashSet<BoundedWindow> knownStateAddressWindows = new HashSet<BoundedWindow>();
        for (Map.Entry<W, Set<W>> entry : this.activeWindowToStateAddressWindows.entrySet()) {
            BoundedWindow active = (BoundedWindow)entry.getKey();
            Preconditions.checkState(!entry.getValue().isEmpty(), "Unexpected empty state address window set for ACTIVE window %s", active);
            for (BoundedWindow stateAddressWindow : entry.getValue()) {
                Preconditions.checkState(knownStateAddressWindows.add(stateAddressWindow), "%s is in more than one state address window set", stateAddressWindow);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MergingActiveWindowSet {\n");
        for (Map.Entry<W, Set<W>> entry : this.activeWindowToStateAddressWindows.entrySet()) {
            BoundedWindow active = (BoundedWindow)entry.getKey();
            Set<W> stateAddressWindows = entry.getValue();
            if (stateAddressWindows.isEmpty()) {
                sb.append("  NEW ");
                sb.append(active);
                sb.append('\n');
                continue;
            }
            sb.append("  ACTIVE ");
            sb.append(active);
            sb.append(":\n");
            for (BoundedWindow stateAddressWindow : stateAddressWindows) {
                sb.append("    ");
                sb.append(stateAddressWindow);
                sb.append("\n");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MergingActiveWindowSet)) {
            return false;
        }
        MergingActiveWindowSet other = (MergingActiveWindowSet)o;
        return this.activeWindowToStateAddressWindows.equals(other.activeWindowToStateAddressWindows);
    }

    public int hashCode() {
        return Objects.hashCode(this.activeWindowToStateAddressWindows);
    }

    private static <W> Map<W, Set<W>> emptyIfNull(@Nullable Map<W, Set<W>> multimap) {
        if (multimap == null) {
            return new HashMap();
        }
        for (Map.Entry<W, Set<W>> entry : multimap.entrySet()) {
            if (entry.getValue() != null) continue;
            entry.setValue(new LinkedHashSet());
        }
        return multimap;
    }

    private static <W> Map<W, Set<W>> deepCopy(Map<W, Set<W>> multimap) {
        HashMap newMultimap = new HashMap();
        for (Map.Entry<W, Set<W>> entry : multimap.entrySet()) {
            newMultimap.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
        }
        return newMultimap;
    }

    static /* synthetic */ WindowFn access$000(MergingActiveWindowSet x0) {
        return x0.windowFn;
    }

    private class MergeContextImpl
    extends WindowFn.MergeContext {
        private ActiveWindowSet.MergeCallback<W> mergeCallback;
        private final List<Collection<W>> allToBeMerged;
        private final List<W> allMergeResults;
        private final Set<W> seen;

        public MergeContextImpl(ActiveWindowSet.MergeCallback<W> mergeCallback) {
            this.mergeCallback = mergeCallback;
            this.allToBeMerged = new ArrayList();
            this.allMergeResults = new ArrayList();
            this.seen = new HashSet();
        }

        @Override
        public Collection<W> windows() {
            return MergingActiveWindowSet.this.activeWindowToStateAddressWindows.keySet();
        }

        @Override
        public void merge(Collection<W> toBeMerged, W mergeResult) throws Exception {
            Preconditions.checkNotNull(toBeMerged);
            Preconditions.checkNotNull(mergeResult);
            ArrayList<BoundedWindow> copyOfToBeMerged = new ArrayList<BoundedWindow>(toBeMerged.size());
            boolean includesMergeResult = false;
            for (BoundedWindow window : toBeMerged) {
                Preconditions.checkNotNull(window);
                Preconditions.checkState(MergingActiveWindowSet.this.isActiveOrNew(window), "Expecting merge window %s to be ACTIVE or NEW", window);
                if (window.equals(mergeResult)) {
                    includesMergeResult = true;
                }
                boolean notDup = this.seen.add(window);
                Preconditions.checkState(notDup, "Expecting merge window %s to appear in at most one merge set", window);
                copyOfToBeMerged.add(window);
            }
            if (!includesMergeResult) {
                Preconditions.checkState(!MergingActiveWindowSet.this.isActive(mergeResult), "Expecting result window %s to be NEW", mergeResult);
            }
            this.allToBeMerged.add(copyOfToBeMerged);
            this.allMergeResults.add(mergeResult);
        }

        public void recordMerges() throws Exception {
            int i;
            for (i = 0; i < this.allToBeMerged.size(); ++i) {
                this.mergeCallback.prefetchOnMerge(this.allToBeMerged.get(i), (BoundedWindow)this.allMergeResults.get(i));
            }
            for (i = 0; i < this.allToBeMerged.size(); ++i) {
                this.mergeCallback.onMerge(this.allToBeMerged.get(i), (BoundedWindow)this.allMergeResults.get(i));
                MergingActiveWindowSet.this.recordMerge(this.allToBeMerged.get(i), (BoundedWindow)this.allMergeResults.get(i));
            }
            this.allToBeMerged.clear();
            this.allMergeResults.clear();
            this.seen.clear();
        }
    }
}

