/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.IllegalMutationException;
import com.google.cloud.dataflow.sdk.util.MutationDetector;
import java.util.Arrays;
import java.util.Objects;

public class MutationDetectors {
    private MutationDetectors() {
    }

    public static <T> MutationDetector forValueWithCoder(T value, Coder<T> coder) throws CoderException {
        if (value == null) {
            return MutationDetectors.noopMutationDetector();
        }
        return new CodedValueMutationDetector<T>(value, coder);
    }

    public static MutationDetector noopMutationDetector() {
        return new NoopMutationDetector();
    }

    private static class CodedValueMutationDetector<T>
    implements MutationDetector {
        private final Coder<T> coder;
        private final T possiblyModifiedObject;
        private final byte[] encodedOriginalObject;
        private final T clonedOriginalObject;

        public CodedValueMutationDetector(T value, Coder<T> coder) throws CoderException {
            this.coder = coder;
            this.possiblyModifiedObject = value;
            this.encodedOriginalObject = CoderUtils.encodeToByteArray(coder, value);
            this.clonedOriginalObject = CoderUtils.decodeFromByteArray(coder, this.encodedOriginalObject);
        }

        @Override
        public void verifyUnmodified() {
            try {
                this.verifyUnmodifiedThrowingCheckedExceptions();
            }
            catch (CoderException exn) {
                throw new RuntimeException(exn);
            }
        }

        private void verifyUnmodifiedThrowingCheckedExceptions() throws CoderException {
            if (Objects.equals(this.possiblyModifiedObject, this.clonedOriginalObject) || Objects.equals(this.clonedOriginalObject, this.possiblyModifiedObject)) {
                return;
            }
            T clonedPossiblyModifiedObject = CoderUtils.clone(this.coder, this.possiblyModifiedObject);
            if (Objects.deepEquals(clonedPossiblyModifiedObject, this.clonedOriginalObject)) {
                return;
            }
            if (Arrays.equals(CoderUtils.encodeToByteArray(this.coder, this.clonedOriginalObject), CoderUtils.encodeToByteArray(this.coder, clonedPossiblyModifiedObject))) {
                return;
            }
            this.illegalMutation(this.clonedOriginalObject, clonedPossiblyModifiedObject);
        }

        private void illegalMutation(T previousValue, T newValue) throws CoderException {
            throw new IllegalMutationException(String.format("Value %s mutated illegally, new value was %s. Encoding was %s, now %s.", previousValue, newValue, CoderUtils.encodeToBase64(this.coder, previousValue), CoderUtils.encodeToBase64(this.coder, newValue)), previousValue, newValue);
        }

        @Override
        public void close() {
            this.verifyUnmodified();
        }
    }

    private static class NoopMutationDetector
    implements MutationDetector {
        private NoopMutationDetector() {
        }

        @Override
        public void verifyUnmodified() {
        }

        @Override
        public void close() {
        }
    }
}

