/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.fasterxml.jackson.core.Base64Variants;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.hash.Funnels;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.hash.Hasher;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.hash.Hashing;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.CountingOutputStream;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.Files;
import com.google.cloud.dataflow.sdk.util.FluentBackoff;
import com.google.cloud.dataflow.sdk.util.IOChannelUtils;
import com.google.cloud.dataflow.sdk.util.ZipFiles;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PackageUtil.class);
    public static final int SANE_CLASSPATH_SIZE = 1000;
    private static final Duration INITIAL_BACKOFF_INTERVAL = Duration.standardSeconds((long)5L);
    private static final int MAX_RETRIES = 4;
    private static final FluentBackoff BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(4).withInitialBackoff(INITIAL_BACKOFF_INTERVAL);
    private static final ApiErrorExtractor ERROR_EXTRACTOR = new ApiErrorExtractor();

    @Deprecated
    public static DataflowPackage createPackage(File classpathElement, String stagingPath, String overridePackageName) {
        return PackageUtil.createPackageAttributes(classpathElement, stagingPath, overridePackageName).getDataflowPackage();
    }

    static PackageAttributes createPackageAttributes(File classpathElement, String stagingPath, String overridePackageName) {
        try {
            boolean directory = classpathElement.isDirectory();
            Hasher hasher = Hashing.md5().newHasher();
            OutputStream hashStream = Funnels.asOutputStream(hasher);
            CountingOutputStream countingOutputStream = new CountingOutputStream(hashStream);
            if (!directory) {
                Files.asByteSource(classpathElement).copyTo(countingOutputStream);
            } else {
                ZipFiles.zipDirectory(classpathElement, countingOutputStream);
            }
            long size = countingOutputStream.getCount();
            String hash = Base64Variants.MODIFIED_FOR_URL.encode(hasher.hash().asBytes());
            String uniqueName = PackageUtil.getUniqueContentName(classpathElement, hash);
            String resourcePath = IOChannelUtils.resolve(stagingPath, uniqueName);
            DataflowPackage target = new DataflowPackage();
            target.setName(overridePackageName != null ? overridePackageName : uniqueName);
            target.setLocation(resourcePath);
            return new PackageAttributes(size, hash, directory, target);
        }
        catch (IOException e) {
            throw new RuntimeException("Package setup failure for " + classpathElement, e);
        }
    }

    public static List<DataflowPackage> stageClasspathElements(Collection<String> classpathElements, String stagingPath) {
        return PackageUtil.stageClasspathElements(classpathElements, stagingPath, Sleeper.DEFAULT);
    }

    static List<DataflowPackage> stageClasspathElements(Collection<String> classpathElements, String stagingPath, Sleeper retrySleeper) {
        LOG.info("Uploading {} files from PipelineOptions.filesToStage to staging location to prepare for execution.", (Object)classpathElements.size());
        if (classpathElements.size() > 1000) {
            LOG.warn("Your classpath contains {} elements, which Google Cloud Dataflow automatically copies to all workers. Having this many entries on your classpath may be indicative of an issue in your pipeline. You may want to consider trimming the classpath to necessary dependencies only, using --filesToStage pipeline option to override what files are being staged, or bundling several dependencies into one.", (Object)classpathElements.size());
        }
        ArrayList<DataflowPackage> packages = new ArrayList<DataflowPackage>();
        if (stagingPath == null) {
            throw new IllegalArgumentException("Can't stage classpath elements on because no staging location has been provided");
        }
        int numUploaded = 0;
        int numCached = 0;
        block15: for (String classpathElement : classpathElements) {
            File file;
            String packageName = null;
            if (classpathElement.contains("=")) {
                String[] components = classpathElement.split("=", 2);
                packageName = components[0];
                classpathElement = components[1];
            }
            if (!(file = new File(classpathElement)).exists()) {
                LOG.warn("Skipping non-existent classpath element {} that was specified.", (Object)classpathElement);
                continue;
            }
            PackageAttributes attributes = PackageUtil.createPackageAttributes(file, stagingPath, packageName);
            DataflowPackage workflowPackage = attributes.getDataflowPackage();
            packages.add(workflowPackage);
            String target = workflowPackage.getLocation();
            try {
                try {
                    long remoteLength = IOChannelUtils.getSizeBytes(target);
                    if (remoteLength == attributes.getSize()) {
                        LOG.debug("Skipping classpath element already staged: {} at {}", (Object)classpathElement, (Object)target);
                        ++numCached;
                        continue;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                BackOff backoff = BACKOFF_FACTORY.backoff();
                while (true) {
                    try {
                        LOG.debug("Uploading classpath element {} to {}", (Object)classpathElement, (Object)target);
                        try (WritableByteChannel writer = IOChannelUtils.create(target, "application/octet-stream");){
                            PackageUtil.copyContent(classpathElement, writer);
                        }
                        ++numUploaded;
                        continue block15;
                    }
                    catch (IOException e) {
                        if (ERROR_EXTRACTOR.accessDenied(e)) {
                            String errorMessage = String.format("Uploaded failed due to permissions error, will NOT retry staging of classpath %s. Please verify credentials are valid and that you have write access to %s. Stale credentials can be resolved by executing 'gcloud auth login'.", classpathElement, target);
                            LOG.error(errorMessage);
                            throw new IOException(errorMessage, e);
                        }
                        long sleep = backoff.nextBackOffMillis();
                        if (sleep == -1L) {
                            LOG.error("Upload failed, will NOT retry staging of classpath: {}", (Object)classpathElement, (Object)e);
                            throw e;
                        }
                        LOG.warn("Upload attempt failed, sleeping before retrying staging of classpath: {}", (Object)classpathElement, (Object)e);
                        retrySleeper.sleep(sleep);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not stage classpath element: " + classpathElement, e);
            }
        }
        LOG.info("Uploading PipelineOptions.filesToStage complete: {} files newly uploaded, {} files cached", (Object)numUploaded, (Object)numCached);
        return packages;
    }

    static String getUniqueContentName(File classpathElement, String contentHash) {
        String fileName = Files.getNameWithoutExtension(classpathElement.getAbsolutePath());
        String fileExtension = Files.getFileExtension(classpathElement.getAbsolutePath());
        if (classpathElement.isDirectory()) {
            return fileName + "-" + contentHash + ".jar";
        }
        if (fileExtension.isEmpty()) {
            return fileName + "-" + contentHash;
        }
        return fileName + "-" + contentHash + "." + fileExtension;
    }

    private static void copyContent(String classpathElement, WritableByteChannel outputChannel) throws IOException {
        File classpathElementFile = new File(classpathElement);
        if (classpathElementFile.isDirectory()) {
            ZipFiles.zipDirectory(classpathElementFile, Channels.newOutputStream(outputChannel));
        } else {
            Files.asByteSource(classpathElementFile).copyTo(Channels.newOutputStream(outputChannel));
        }
    }

    static class PackageAttributes {
        private final boolean directory;
        private final long size;
        private final String hash;
        private DataflowPackage dataflowPackage;

        public PackageAttributes(long size, String hash, boolean directory, DataflowPackage dataflowPackage) {
            this.size = size;
            this.hash = Objects.requireNonNull(hash, "hash");
            this.directory = directory;
            this.dataflowPackage = Objects.requireNonNull(dataflowPackage, "dataflowPackage");
        }

        public DataflowPackage getDataflowPackage() {
            return this.dataflowPackage;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public long getSize() {
            return this.size;
        }

        public String getHash() {
            return this.hash;
        }
    }
}

