/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.NanoClock;
import com.google.api.client.util.Sleeper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHttpRequestInitializer
implements HttpRequestInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(RetryHttpRequestInitializer.class);
    private static final Set<Integer> DEFAULT_IGNORED_RESPONSE_CODES = new HashSet<Integer>(Arrays.asList(307, 308));
    private static final int HANGING_GET_TIMEOUT_SEC = 80;
    @Deprecated
    private final HttpRequestInitializer chained;
    private final HttpResponseInterceptor responseInterceptor;
    private final NanoClock nanoClock;
    private final Sleeper sleeper;
    private Set<Integer> ignoredResponseCodes = new HashSet<Integer>(DEFAULT_IGNORED_RESPONSE_CODES);

    public RetryHttpRequestInitializer() {
        this(Collections.emptyList());
    }

    @Deprecated
    public RetryHttpRequestInitializer(@Nullable HttpRequestInitializer chained) {
        this(chained, Collections.emptyList());
    }

    public RetryHttpRequestInitializer(Collection<Integer> additionalIgnoredResponseCodes) {
        this(additionalIgnoredResponseCodes, null);
    }

    @Deprecated
    public RetryHttpRequestInitializer(@Nullable HttpRequestInitializer chained, Collection<Integer> additionalIgnoredResponseCodes) {
        this(chained, additionalIgnoredResponseCodes, null);
    }

    public RetryHttpRequestInitializer(Collection<Integer> additionalIgnoredResponseCodes, @Nullable HttpResponseInterceptor responseInterceptor) {
        this(null, NanoClock.SYSTEM, Sleeper.DEFAULT, additionalIgnoredResponseCodes, responseInterceptor);
    }

    @Deprecated
    public RetryHttpRequestInitializer(@Nullable HttpRequestInitializer chained, Collection<Integer> additionalIgnoredResponseCodes, @Nullable HttpResponseInterceptor responseInterceptor) {
        this(chained, NanoClock.SYSTEM, Sleeper.DEFAULT, additionalIgnoredResponseCodes, responseInterceptor);
    }

    RetryHttpRequestInitializer(@Nullable HttpRequestInitializer chained, NanoClock nanoClock, Sleeper sleeper, Collection<Integer> additionalIgnoredResponseCodes, HttpResponseInterceptor responseInterceptor) {
        this.chained = chained;
        this.nanoClock = nanoClock;
        this.sleeper = sleeper;
        this.ignoredResponseCodes.addAll(additionalIgnoredResponseCodes);
        this.responseInterceptor = responseInterceptor;
    }

    public void initialize(HttpRequest request) throws IOException {
        if (this.chained != null) {
            this.chained.initialize(request);
        }
        request.setReadTimeout(80000);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new LoggingHttpBackoffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff.Builder().setNanoClock(this.nanoClock).setMultiplier(2.0).build(), this.sleeper, this.ignoredResponseCodes));
        LoggingHttpBackOffIOExceptionHandler loggingBackoffHandler = new LoggingHttpBackOffIOExceptionHandler(BackOff.ZERO_BACKOFF);
        request.setIOExceptionHandler((HttpIOExceptionHandler)loggingBackoffHandler);
        if (this.responseInterceptor != null) {
            request.setResponseInterceptor(this.responseInterceptor);
        }
    }

    private static class LoggingHttpBackoffUnsuccessfulResponseHandler
    implements HttpUnsuccessfulResponseHandler {
        private final HttpBackOffUnsuccessfulResponseHandler handler;
        private final Set<Integer> ignoredResponseCodes;

        public LoggingHttpBackoffUnsuccessfulResponseHandler(BackOff backoff, Sleeper sleeper, Set<Integer> ignoredResponseCodes) {
            this.ignoredResponseCodes = ignoredResponseCodes;
            this.handler = new HttpBackOffUnsuccessfulResponseHandler(backoff);
            this.handler.setSleeper(sleeper);
            this.handler.setBackOffRequired(new HttpBackOffUnsuccessfulResponseHandler.BackOffRequired(){

                public boolean isRequired(HttpResponse response) {
                    int statusCode = response.getStatusCode();
                    return statusCode / 100 == 5 || statusCode == 429;
                }
            });
        }

        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
            boolean retry = this.handler.handleResponse(request, response, supportsRetry);
            if (retry) {
                LOG.debug("Request failed with code {} will retry: {}", (Object)response.getStatusCode(), (Object)request.getUrl());
            } else if (!this.ignoredResponseCodes.contains(response.getStatusCode())) {
                LOG.warn("Request failed with code {}, will NOT retry: {}", (Object)response.getStatusCode(), (Object)request.getUrl());
            }
            return retry;
        }
    }

    private static class LoggingHttpBackOffIOExceptionHandler
    extends HttpBackOffIOExceptionHandler {
        public LoggingHttpBackOffIOExceptionHandler(BackOff backOff) {
            super(backOff);
        }

        public boolean handleIOException(HttpRequest request, boolean supportsRetry) throws IOException {
            boolean willRetry = super.handleIOException(request, supportsRetry);
            if (willRetry) {
                LOG.debug("Request failed with IOException, will retry: {}", (Object)request.getUrl());
            } else {
                LOG.warn("Request failed with IOException, will NOT retry: {}", (Object)request.getUrl());
            }
            return willRetry;
        }
    }
}

