/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SerializableUtils {
    public static byte[] serializeToByteArray(Serializable value) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new SnappyOutputStream((OutputStream)buffer));){
                oos.writeObject(value);
            }
            return buffer.toByteArray();
        }
        catch (IOException exn) {
            throw new IllegalArgumentException("unable to serialize " + value, exn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserializeFromByteArray(byte[] encodedValue, String description) {
        try (ObjectInputStream ois = new ObjectInputStream((InputStream)new SnappyInputStream((InputStream)new ByteArrayInputStream(encodedValue)));){
            Object object = ois.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException exn) {
            throw new IllegalArgumentException("unable to deserialize " + description, exn);
        }
    }

    public static <T extends Serializable> T ensureSerializable(T value) {
        Serializable copy = (Serializable)SerializableUtils.deserializeFromByteArray(SerializableUtils.serializeToByteArray(value), value.toString());
        return (T)copy;
    }

    public static <T extends Serializable> T clone(T value) {
        Serializable copy = (Serializable)SerializableUtils.deserializeFromByteArray(SerializableUtils.serializeToByteArray(value), value.toString());
        return (T)copy;
    }

    public static CloudObject ensureSerializable(Coder<?> coder) {
        Coder decoded;
        Coder<?> copy = SerializableUtils.ensureSerializable(coder);
        CloudObject cloudObject = copy.asCloudObject();
        try {
            decoded = Serializer.deserialize((Map<String, Object>)((Object)cloudObject), Coder.class);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Unable to deserialize Coder: %s. Check that a suitable constructor is defined.  See Coder for details.", coder), e);
        }
        Preconditions.checkState(coder.equals(decoded), String.format("Coder not equal to original after serialization, indicating that the Coder may not implement serialization correctly.  Before: %s, after: %s, cloud encoding: %s", new Object[]{coder, decoded, cloudObject}));
        return cloudObject;
    }

    public static <T> T ensureSerializableByCoder(Coder<T> coder, T value, String errorContext) {
        byte[] encodedValue;
        try {
            encodedValue = CoderUtils.encodeToByteArray(coder, value);
        }
        catch (CoderException exn) {
            throw new IllegalArgumentException(errorContext + ": unable to encode value " + value + " using " + coder, exn);
        }
        try {
            return CoderUtils.decodeFromByteArray(coder, encodedValue);
        }
        catch (CoderException exn) {
            throw new IllegalArgumentException(errorContext + ": unable to decode " + Arrays.toString(encodedValue) + ", encoding of value " + value + ", using " + coder, exn);
        }
    }
}

