/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.InstantCoder;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.coders.StringUtf8Coder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ComparisonChain;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import com.google.cloud.dataflow.sdk.util.state.StateNamespaces;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public interface TimerInternals {
    public void setTimer(TimerData var1);

    public void deleteTimer(TimerData var1);

    public Instant currentProcessingTime();

    @Nullable
    public Instant currentSynchronizedProcessingTime();

    public Instant currentInputWatermarkTime();

    @Nullable
    public Instant currentOutputWatermarkTime();

    public static class TimerDataCoder
    extends StandardCoder<TimerData> {
        private static final StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final InstantCoder INSTANT_CODER = InstantCoder.of();
        private final Coder<? extends BoundedWindow> windowCoder;

        public static TimerDataCoder of(Coder<? extends BoundedWindow> windowCoder) {
            return new TimerDataCoder(windowCoder);
        }

        @JsonCreator
        public static TimerDataCoder of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
            Preconditions.checkArgument(components.size() == 1, "Expecting 1 components, got " + components.size());
            return TimerDataCoder.of(components.get(0));
        }

        private TimerDataCoder(Coder<? extends BoundedWindow> windowCoder) {
            this.windowCoder = windowCoder;
        }

        @Override
        public void encode(TimerData timer, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            Coder.Context nestedContext = context.nested();
            STRING_CODER.encode(timer.namespace.stringKey(), outStream, nestedContext);
            INSTANT_CODER.encode(timer.timestamp, outStream, nestedContext);
            STRING_CODER.encode(timer.domain.name(), outStream, nestedContext);
        }

        @Override
        public TimerData decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            Coder.Context nestedContext = context.nested();
            StateNamespace namespace = StateNamespaces.fromString(STRING_CODER.decode(inStream, nestedContext), this.windowCoder);
            Instant timestamp = INSTANT_CODER.decode(inStream, nestedContext);
            TimeDomain domain = TimeDomain.valueOf(STRING_CODER.decode(inStream, nestedContext));
            return TimerData.of(namespace, timestamp, domain);
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.windowCoder);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.verifyDeterministic("window coder must be deterministic", this.windowCoder);
        }
    }

    public static class TimerData
    implements Comparable<TimerData> {
        private final StateNamespace namespace;
        private final Instant timestamp;
        private final TimeDomain domain;

        private TimerData(StateNamespace namespace, Instant timestamp, TimeDomain domain) {
            this.namespace = Preconditions.checkNotNull(namespace);
            this.timestamp = Preconditions.checkNotNull(timestamp);
            this.domain = Preconditions.checkNotNull(domain);
        }

        public StateNamespace getNamespace() {
            return this.namespace;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public TimeDomain getDomain() {
            return this.domain;
        }

        public static TimerData of(StateNamespace namespace, Instant timestamp, TimeDomain domain) {
            return new TimerData(namespace, timestamp, domain);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TimerData)) {
                return false;
            }
            TimerData that = (TimerData)obj;
            return Objects.equals((Object)this.domain, (Object)that.domain) && this.timestamp.isEqual((ReadableInstant)that.timestamp) && Objects.equals(this.namespace, that.namespace);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.domain, this.timestamp, this.namespace});
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("namespace", this.namespace).add("timestamp", this.timestamp).add("domain", (Object)this.domain).toString();
        }

        @Override
        public int compareTo(TimerData o) {
            ComparisonChain chain = ComparisonChain.start().compare(this.timestamp.getMillis(), o.getTimestamp().getMillis()).compare((Comparable<?>)((Object)this.domain), (Comparable<?>)((Object)o.domain));
            if (chain.result() == 0) {
                chain = chain.compare((Comparable<?>)((Object)this.namespace.stringKey()), (Comparable<?>)((Object)o.namespace.stringKey()));
            }
            return chain.result();
        }
    }
}

