/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Predicate;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.FluentIterable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ActiveWindowSet;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import com.google.cloud.dataflow.sdk.util.FinishedTriggers;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.Timers;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.state.MergingStateAccessor;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateAccessor;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import com.google.cloud.dataflow.sdk.util.state.StateNamespaces;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.Instant;

public class TriggerContextFactory<W extends BoundedWindow> {
    private final WindowingStrategy<?, W> windowingStrategy;
    private StateInternals<?> stateInternals;
    private ActiveWindowSet<W> activeWindows;
    private final Coder<W> windowCoder;

    public TriggerContextFactory(WindowingStrategy<?, W> windowingStrategy, StateInternals<?> stateInternals, ActiveWindowSet<W> activeWindows) {
        this.windowingStrategy = windowingStrategy;
        this.stateInternals = stateInternals;
        this.activeWindows = activeWindows;
        this.windowCoder = windowingStrategy.getWindowFn().windowCoder();
    }

    public Trigger.TriggerContext base(W window, Timers timers, ExecutableTrigger<W> rootTrigger, FinishedTriggers finishedSet) {
        return new TriggerContextImpl(this, (BoundedWindow)window, timers, rootTrigger, finishedSet);
    }

    public Trigger.OnElementContext createOnElementContext(W window, Timers timers, Instant elementTimestamp, ExecutableTrigger<W> rootTrigger, FinishedTriggers finishedSet) {
        return new OnElementContextImpl(this, (BoundedWindow)window, timers, rootTrigger, finishedSet, elementTimestamp);
    }

    public Trigger.OnMergeContext createOnMergeContext(W window, Timers timers, ExecutableTrigger<W> rootTrigger, FinishedTriggers finishedSet, Map<W, FinishedTriggers> finishedSets) {
        return new OnMergeContextImpl(this, (BoundedWindow)window, timers, rootTrigger, finishedSet, finishedSets);
    }

    public StateAccessor<?> createStateAccessor(W window, ExecutableTrigger<W> trigger) {
        return new StateAccessorImpl(this, window, trigger);
    }

    public MergingStateAccessor<?, W> createMergingStateAccessor(W mergeResult, Collection<W> mergingWindows, ExecutableTrigger<W> trigger) {
        return new MergingStateAccessorImpl(this, trigger, mergingWindows, mergeResult);
    }

    private static class OnMergeContextImpl
    extends Trigger.OnMergeContext {
        private final MergingStateAccessor<?, W> state;
        private final W window;
        private final Collection<W> mergingWindows;
        private final Timers timers;
        private final MergingTriggerInfoImpl triggerInfo;
        final /* synthetic */ TriggerContextFactory this$0;

        private OnMergeContextImpl(W window, Timers timers, ExecutableTrigger<W> trigger, FinishedTriggers finishedSet, Map<W, FinishedTriggers> finishedSets) {
            this.this$0 = var1_1;
            this.mergingWindows = finishedSets.keySet();
            this.window = window;
            this.state = new MergingStateAccessorImpl((TriggerContextFactory)var1_1, trigger, this.mergingWindows, window);
            this.timers = new TriggerTimers((TriggerContextFactory)var1_1, window, timers);
            this.triggerInfo = var1_1.new MergingTriggerInfoImpl(trigger, finishedSet, this, finishedSets);
        }

        @Override
        public Trigger.OnMergeContext forTrigger(ExecutableTrigger<W> trigger) {
            return new OnMergeContextImpl(this.this$0, this.window, this.timers, trigger, this.triggerInfo.finishedSet, this.triggerInfo.finishedSets);
        }

        @Override
        public MergingStateAccessor<?, W> state() {
            return this.state;
        }

        @Override
        public Trigger.MergingTriggerInfo<W> trigger() {
            return this.triggerInfo;
        }

        @Override
        public W window() {
            return this.window;
        }

        @Override
        public void setTimer(Instant timestamp, TimeDomain domain) {
            this.timers.setTimer(timestamp, domain);
        }

        @Override
        public void deleteTimer(Instant timestamp, TimeDomain domain) {
            this.timers.setTimer(timestamp, domain);
        }

        @Override
        public Instant currentProcessingTime() {
            return this.timers.currentProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentSynchronizedProcessingTime() {
            return this.timers.currentSynchronizedProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentEventTime() {
            return this.timers.currentEventTime();
        }
    }

    private static class OnElementContextImpl
    extends Trigger.OnElementContext {
        private final W window;
        private final StateAccessorImpl state;
        private final Timers timers;
        private final TriggerInfoImpl triggerInfo;
        private final Instant eventTimestamp;
        final /* synthetic */ TriggerContextFactory this$0;

        private OnElementContextImpl(W window, Timers timers, ExecutableTrigger<W> trigger, FinishedTriggers finishedSet, Instant eventTimestamp) {
            this.this$0 = var1_1;
            this.window = window;
            this.state = new StateAccessorImpl((TriggerContextFactory)var1_1, window, trigger);
            this.timers = new TriggerTimers((TriggerContextFactory)var1_1, window, timers);
            this.triggerInfo = var1_1.new TriggerInfoImpl(trigger, finishedSet, this);
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public Instant eventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        public Trigger.OnElementContext forTrigger(ExecutableTrigger<W> trigger) {
            return new OnElementContextImpl(this.this$0, this.window, this.timers, trigger, this.triggerInfo.finishedSet, this.eventTimestamp);
        }

        @Override
        public Trigger.TriggerInfo<W> trigger() {
            return this.triggerInfo;
        }

        public StateAccessor state() {
            return this.state;
        }

        @Override
        public W window() {
            return this.window;
        }

        @Override
        public void setTimer(Instant timestamp, TimeDomain domain) {
            this.timers.setTimer(timestamp, domain);
        }

        @Override
        public void deleteTimer(Instant timestamp, TimeDomain domain) {
            this.timers.deleteTimer(timestamp, domain);
        }

        @Override
        public Instant currentProcessingTime() {
            return this.timers.currentProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentSynchronizedProcessingTime() {
            return this.timers.currentSynchronizedProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentEventTime() {
            return this.timers.currentEventTime();
        }
    }

    private static class TriggerContextImpl
    extends Trigger.TriggerContext {
        private final W window;
        private final StateAccessorImpl state;
        private final Timers timers;
        private final TriggerInfoImpl triggerInfo;
        final /* synthetic */ TriggerContextFactory this$0;

        private TriggerContextImpl(W window, Timers timers, ExecutableTrigger<W> trigger, FinishedTriggers finishedSet) {
            this.this$0 = var1_1;
            this.window = window;
            this.state = new StateAccessorImpl((TriggerContextFactory)var1_1, window, trigger);
            this.timers = new TriggerTimers((TriggerContextFactory)var1_1, window, timers);
            this.triggerInfo = var1_1.new TriggerInfoImpl(trigger, finishedSet, this);
        }

        @Override
        public Trigger.TriggerContext forTrigger(ExecutableTrigger<W> trigger) {
            return new TriggerContextImpl(this.this$0, this.window, this.timers, trigger, this.triggerInfo.finishedSet);
        }

        @Override
        public Trigger.TriggerInfo<W> trigger() {
            return this.triggerInfo;
        }

        public StateAccessor state() {
            return this.state;
        }

        @Override
        public W window() {
            return this.window;
        }

        @Override
        public void deleteTimer(Instant timestamp, TimeDomain domain) {
            this.timers.deleteTimer(timestamp, domain);
        }

        @Override
        public Instant currentProcessingTime() {
            return this.timers.currentProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentSynchronizedProcessingTime() {
            return this.timers.currentSynchronizedProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentEventTime() {
            return this.timers.currentEventTime();
        }
    }

    private static class MergingStateAccessorImpl
    extends StateAccessorImpl
    implements MergingStateAccessor<Object, W> {
        private final Collection<W> activeToBeMerged;
        final /* synthetic */ TriggerContextFactory this$0;

        public MergingStateAccessorImpl(ExecutableTrigger<W> trigger, Collection<W> activeToBeMerged, W mergeResult) {
            this.this$0 = var1_1;
            super((TriggerContextFactory)var1_1, mergeResult, trigger);
            this.activeToBeMerged = activeToBeMerged;
        }

        @Override
        public <StateT extends State> StateT access(StateTag<? super Object, StateT> address) {
            return this.this$0.stateInternals.state(this.windowNamespace, address);
        }

        @Override
        public <StateT extends State> Map<W, StateT> accessInEachMergingWindow(StateTag<? super Object, StateT> address) {
            ImmutableMap.Builder<BoundedWindow, StateT> builder = ImmutableMap.builder();
            for (BoundedWindow mergingWindow : this.activeToBeMerged) {
                StateT stateForWindow = this.this$0.stateInternals.state(this.namespaceFor(mergingWindow), address);
                builder.put(mergingWindow, stateForWindow);
            }
            return builder.build();
        }
    }

    private static class StateAccessorImpl
    implements StateAccessor<Object> {
        protected final int triggerIndex;
        protected final StateNamespace windowNamespace;
        final /* synthetic */ TriggerContextFactory this$0;

        public StateAccessorImpl(W window, ExecutableTrigger<W> trigger) {
            this.this$0 = var1_1;
            this.triggerIndex = trigger.getTriggerIndex();
            this.windowNamespace = this.namespaceFor(window);
        }

        protected StateNamespace namespaceFor(W window) {
            return StateNamespaces.windowAndTrigger(this.this$0.windowCoder, window, this.triggerIndex);
        }

        @Override
        public <StateT extends State> StateT access(StateTag<? super Object, StateT> address) {
            return this.this$0.stateInternals.state(this.windowNamespace, address);
        }
    }

    private class MergingTriggerInfoImpl
    extends TriggerInfoImpl
    implements Trigger.MergingTriggerInfo<W> {
        private final Map<W, FinishedTriggers> finishedSets;

        public MergingTriggerInfoImpl(ExecutableTrigger<W> trigger, FinishedTriggers finishedSet, Trigger.TriggerContext context, Map<W, FinishedTriggers> finishedSets) {
            super(trigger, finishedSet, context);
            this.finishedSets = finishedSets;
        }

        @Override
        public boolean finishedInAnyMergingWindow() {
            for (FinishedTriggers finishedSet : this.finishedSets.values()) {
                if (!finishedSet.isFinished(this.trigger)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean finishedInAllMergingWindows() {
            for (FinishedTriggers finishedSet : this.finishedSets.values()) {
                if (finishedSet.isFinished(this.trigger)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterable<W> getFinishedMergingWindows() {
            return Maps.filterValues(this.finishedSets, new Predicate<FinishedTriggers>(){

                @Override
                public boolean apply(FinishedTriggers finishedSet) {
                    return finishedSet.isFinished(MergingTriggerInfoImpl.this.trigger);
                }
            }).keySet();
        }
    }

    private static class TriggerTimers
    implements Timers {
        private final Timers timers;
        private final W window;
        final /* synthetic */ TriggerContextFactory this$0;

        public TriggerTimers(W window, Timers timers) {
            this.this$0 = var1_1;
            this.timers = timers;
            this.window = window;
        }

        @Override
        public void setTimer(Instant timestamp, TimeDomain timeDomain) {
            this.timers.setTimer(timestamp, timeDomain);
        }

        @Override
        public void deleteTimer(Instant timestamp, TimeDomain timeDomain) {
            if (timeDomain == TimeDomain.EVENT_TIME && timestamp.equals((Object)((BoundedWindow)this.window).maxTimestamp())) {
                return;
            }
            this.timers.deleteTimer(timestamp, timeDomain);
        }

        @Override
        public Instant currentProcessingTime() {
            return this.timers.currentProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentSynchronizedProcessingTime() {
            return this.timers.currentSynchronizedProcessingTime();
        }

        @Override
        public Instant currentEventTime() {
            return this.timers.currentEventTime();
        }
    }

    private class TriggerInfoImpl
    implements Trigger.TriggerInfo<W> {
        protected final ExecutableTrigger<W> trigger;
        protected final FinishedTriggers finishedSet;
        private final Trigger.TriggerContext context;

        public TriggerInfoImpl(ExecutableTrigger<W> trigger, FinishedTriggers finishedSet, Trigger.TriggerContext context) {
            this.trigger = trigger;
            this.finishedSet = finishedSet;
            this.context = context;
        }

        @Override
        public boolean isMerging() {
            return !TriggerContextFactory.this.windowingStrategy.getWindowFn().isNonMerging();
        }

        @Override
        public Iterable<ExecutableTrigger<W>> subTriggers() {
            return this.trigger.subTriggers();
        }

        @Override
        public ExecutableTrigger<W> subTrigger(int subtriggerIndex) {
            return this.trigger.subTriggers().get(subtriggerIndex);
        }

        @Override
        public boolean isFinished() {
            return this.finishedSet.isFinished(this.trigger);
        }

        @Override
        public boolean isFinished(int subtriggerIndex) {
            return this.finishedSet.isFinished(this.subTrigger(subtriggerIndex));
        }

        @Override
        public boolean areAllSubtriggersFinished() {
            return Iterables.isEmpty(this.unfinishedSubTriggers());
        }

        @Override
        public Iterable<ExecutableTrigger<W>> unfinishedSubTriggers() {
            return FluentIterable.from(this.trigger.subTriggers()).filter(new Predicate<ExecutableTrigger<W>>(){

                @Override
                public boolean apply(ExecutableTrigger<W> trigger) {
                    return !TriggerInfoImpl.this.finishedSet.isFinished(trigger);
                }
            });
        }

        @Override
        public ExecutableTrigger<W> firstUnfinishedSubTrigger() {
            for (ExecutableTrigger subTrigger : this.trigger.subTriggers()) {
                if (this.finishedSet.isFinished(subTrigger)) continue;
                return subTrigger;
            }
            return null;
        }

        @Override
        public void resetTree() throws Exception {
            this.finishedSet.clearRecursively(this.trigger);
            this.trigger.invokeClear(this.context);
        }

        @Override
        public void setFinished(boolean finished) {
            this.finishedSet.setFinished(this.trigger, finished);
        }

        @Override
        public void setFinished(boolean finished, int subTriggerIndex) {
            this.finishedSet.setFinished(this.subTrigger(subTriggerIndex), finished);
        }
    }
}

