/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import java.util.Arrays;
import java.util.Objects;

public class UserCodeException
extends RuntimeException {
    public static UserCodeException wrap(Throwable t) {
        if (t instanceof UserCodeException) {
            return (UserCodeException)t;
        }
        return new UserCodeException(t);
    }

    public static RuntimeException wrapIf(boolean condition, Throwable t) {
        if (condition) {
            return UserCodeException.wrap(t);
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t);
    }

    private UserCodeException(Throwable t) {
        super(t);
        this.truncateStackTrace(t);
    }

    private void truncateStackTrace(Throwable t) {
        StackTraceElement[] currentStack = Thread.currentThread().getStackTrace();
        StackTraceElement[] throwableStack = t.getStackTrace();
        int currentStackSize = currentStack.length;
        int throwableStackSize = throwableStack.length;
        if (throwableStackSize == 0) {
            return;
        }
        int commonFrames = 0;
        while (this.framesEqual(currentStack[currentStackSize - commonFrames - 1], throwableStack[throwableStackSize - commonFrames - 1]) && ++commonFrames < Math.min(currentStackSize, throwableStackSize)) {
        }
        StackTraceElement[] truncatedStack = Arrays.copyOfRange(throwableStack, 0, throwableStackSize - commonFrames);
        t.setStackTrace(truncatedStack);
    }

    private boolean framesEqual(StackTraceElement frame1, StackTraceElement frame2) {
        boolean areEqual = Objects.equals(frame1.getClassName(), frame2.getClassName());
        return areEqual &= Objects.equals(frame1.getMethodName(), frame2.getMethodName());
    }
}

