/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.CombineWithContext;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFn;
import com.google.cloud.dataflow.sdk.util.CombineFnUtil;
import com.google.cloud.dataflow.sdk.util.state.AccumulatorCombiningState;
import com.google.cloud.dataflow.sdk.util.state.BagState;
import com.google.cloud.dataflow.sdk.util.state.ReadableState;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateContext;
import com.google.cloud.dataflow.sdk.util.state.StateContexts;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import com.google.cloud.dataflow.sdk.util.state.StateTable;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import com.google.cloud.dataflow.sdk.util.state.WatermarkHoldState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.STATE)
public class InMemoryStateInternals<K>
implements StateInternals<K> {
    private final K key;
    protected final StateTable<K> inMemoryState = new StateTable<K>(){

        @Override
        protected StateTag.StateBinder<K> binderForNamespace(StateNamespace namespace, StateContext<?> c) {
            return new InMemoryStateBinder<Object>(InMemoryStateInternals.this.key, c);
        }
    };

    public static <K> InMemoryStateInternals<K> forKey(K key) {
        return new InMemoryStateInternals<K>(key);
    }

    protected InMemoryStateInternals(K key) {
        this.key = key;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public void clear() {
        this.inMemoryState.clear();
    }

    protected boolean isEmptyForTesting(State state) {
        return ((InMemoryState)((Object)state)).isCleared();
    }

    @Override
    public <T extends State> T state(StateNamespace namespace, StateTag<? super K, T> address) {
        return this.inMemoryState.get(namespace, address, StateContexts.nullContext());
    }

    @Override
    public <T extends State> T state(StateNamespace namespace, StateTag<? super K, T> address, StateContext<?> c) {
        return this.inMemoryState.get(namespace, address, c);
    }

    static final class InMemoryBag<T>
    implements BagState<T>,
    InMemoryState<InMemoryBag<T>> {
        private List<T> contents = new ArrayList<T>();

        InMemoryBag() {
        }

        @Override
        public void clear() {
            this.contents = new ArrayList<T>();
        }

        @Override
        public InMemoryBag<T> readLater() {
            return this;
        }

        @Override
        public Iterable<T> read() {
            return this.contents;
        }

        @Override
        public void add(T input) {
            this.contents.add(input);
        }

        @Override
        public boolean isCleared() {
            return this.contents.isEmpty();
        }

        @Override
        public ReadableState<Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                @Override
                public ReadableState<Boolean> readLater() {
                    return this;
                }

                @Override
                public Boolean read() {
                    return InMemoryBag.this.contents.isEmpty();
                }
            };
        }

        @Override
        public InMemoryBag<T> copy() {
            InMemoryBag<T> that = new InMemoryBag<T>();
            that.contents.addAll(this.contents);
            return that;
        }
    }

    static final class InMemoryCombiningValue<K, InputT, AccumT, OutputT>
    implements AccumulatorCombiningState<InputT, AccumT, OutputT>,
    InMemoryState<InMemoryCombiningValue<K, InputT, AccumT, OutputT>> {
        private final K key;
        private boolean isCleared = true;
        private final Combine.KeyedCombineFn<? super K, InputT, AccumT, OutputT> combineFn;
        private AccumT accum;

        InMemoryCombiningValue(K key, Combine.KeyedCombineFn<? super K, InputT, AccumT, OutputT> combineFn) {
            this.key = key;
            this.combineFn = combineFn;
            this.accum = combineFn.createAccumulator(key);
        }

        public InMemoryCombiningValue<K, InputT, AccumT, OutputT> readLater() {
            return this;
        }

        @Override
        public void clear() {
            this.accum = this.combineFn.createAccumulator(this.key);
            this.isCleared = true;
        }

        @Override
        public OutputT read() {
            return this.combineFn.extractOutput(this.key, this.accum);
        }

        @Override
        public void add(InputT input) {
            this.isCleared = false;
            this.accum = this.combineFn.addInput(this.key, this.accum, input);
        }

        @Override
        public AccumT getAccum() {
            return this.accum;
        }

        @Override
        public ReadableState<Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                @Override
                public ReadableState<Boolean> readLater() {
                    return this;
                }

                @Override
                public Boolean read() {
                    return InMemoryCombiningValue.this.isCleared;
                }
            };
        }

        @Override
        public void addAccum(AccumT accum) {
            this.isCleared = false;
            this.accum = this.combineFn.mergeAccumulators(this.key, Arrays.asList(this.accum, accum));
        }

        @Override
        public AccumT mergeAccumulators(Iterable<AccumT> accumulators) {
            return this.combineFn.mergeAccumulators(this.key, accumulators);
        }

        @Override
        public boolean isCleared() {
            return this.isCleared;
        }

        @Override
        public InMemoryCombiningValue<K, InputT, AccumT, OutputT> copy() {
            InMemoryCombiningValue<K, InputT, AccumT, OutputT> that = new InMemoryCombiningValue<K, InputT, AccumT, OutputT>(this.key, this.combineFn);
            if (!this.isCleared) {
                that.isCleared = this.isCleared;
                that.addAccum(this.accum);
            }
            return that;
        }
    }

    static final class InMemoryWatermarkHold<W extends BoundedWindow>
    implements WatermarkHoldState<W>,
    InMemoryState<InMemoryWatermarkHold<W>> {
        private final OutputTimeFn<? super W> outputTimeFn;
        @Nullable
        private Instant combinedHold = null;

        public InMemoryWatermarkHold(OutputTimeFn<? super W> outputTimeFn) {
            this.outputTimeFn = outputTimeFn;
        }

        @Override
        public InMemoryWatermarkHold<W> readLater() {
            return this;
        }

        @Override
        public void clear() {
            this.combinedHold = null;
        }

        @Override
        public Instant read() {
            return this.combinedHold;
        }

        @Override
        public void add(Instant outputTime) {
            this.combinedHold = this.combinedHold == null ? outputTime : this.outputTimeFn.combine(this.combinedHold, outputTime);
        }

        @Override
        public boolean isCleared() {
            return this.combinedHold == null;
        }

        @Override
        public ReadableState<Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                @Override
                public ReadableState<Boolean> readLater() {
                    return this;
                }

                @Override
                public Boolean read() {
                    return InMemoryWatermarkHold.this.combinedHold == null;
                }
            };
        }

        @Override
        public OutputTimeFn<? super W> getOutputTimeFn() {
            return this.outputTimeFn;
        }

        public String toString() {
            return Objects.toString(this.combinedHold);
        }

        @Override
        public InMemoryWatermarkHold<W> copy() {
            InMemoryWatermarkHold<? super W> that = new InMemoryWatermarkHold<W>(this.outputTimeFn);
            that.combinedHold = this.combinedHold;
            return that;
        }
    }

    static final class InMemoryValue<T>
    implements ValueState<T>,
    InMemoryState<InMemoryValue<T>> {
        private boolean isCleared = true;
        private T value = null;

        InMemoryValue() {
        }

        @Override
        public void clear() {
            this.value = null;
            this.isCleared = true;
        }

        @Override
        public InMemoryValue<T> readLater() {
            return this;
        }

        @Override
        public T read() {
            return this.value;
        }

        @Override
        public void write(T input) {
            this.isCleared = false;
            this.value = input;
        }

        @Override
        public InMemoryValue<T> copy() {
            InMemoryValue<T> that = new InMemoryValue<T>();
            if (!this.isCleared) {
                that.isCleared = this.isCleared;
                that.value = this.value;
            }
            return that;
        }

        @Override
        public boolean isCleared() {
            return this.isCleared;
        }
    }

    static class InMemoryStateBinder<K>
    implements StateTag.StateBinder<K> {
        private final K key;
        private final StateContext<?> c;

        InMemoryStateBinder(K key, StateContext<?> c) {
            this.key = key;
            this.c = c;
        }

        @Override
        public <T> ValueState<T> bindValue(StateTag<? super K, ValueState<T>> address, Coder<T> coder) {
            return new InMemoryValue();
        }

        @Override
        public <T> BagState<T> bindBag(StateTag<? super K, BagState<T>> address, Coder<T> elemCoder) {
            return new InMemoryBag();
        }

        @Override
        public <InputT, AccumT, OutputT> AccumulatorCombiningState<InputT, AccumT, OutputT> bindCombiningValue(StateTag<? super K, AccumulatorCombiningState<InputT, AccumT, OutputT>> address, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            return new InMemoryCombiningValue(this.key, combineFn.asKeyedFn());
        }

        @Override
        public <W extends BoundedWindow> WatermarkHoldState<W> bindWatermark(StateTag<? super K, WatermarkHoldState<W>> address, OutputTimeFn<? super W> outputTimeFn) {
            return new InMemoryWatermarkHold<W>(outputTimeFn);
        }

        @Override
        public <InputT, AccumT, OutputT> AccumulatorCombiningState<InputT, AccumT, OutputT> bindKeyedCombiningValue(StateTag<? super K, AccumulatorCombiningState<InputT, AccumT, OutputT>> address, Coder<AccumT> accumCoder, Combine.KeyedCombineFn<? super K, InputT, AccumT, OutputT> combineFn) {
            return new InMemoryCombiningValue<K, InputT, AccumT, OutputT>(this.key, combineFn);
        }

        @Override
        public <InputT, AccumT, OutputT> AccumulatorCombiningState<InputT, AccumT, OutputT> bindKeyedCombiningValueWithContext(StateTag<? super K, AccumulatorCombiningState<InputT, AccumT, OutputT>> address, Coder<AccumT> accumCoder, CombineWithContext.KeyedCombineFnWithContext<? super K, InputT, AccumT, OutputT> combineFn) {
            return this.bindKeyedCombiningValue(address, accumCoder, CombineFnUtil.bindContext(combineFn, this.c));
        }
    }

    static interface InMemoryState<T extends InMemoryState<T>> {
        public boolean isCleared();

        public T copy();
    }
}

