/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.WindowingInternals;
import com.google.cloud.dataflow.sdk.util.state.StateContext;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import javax.annotation.Nullable;

public class StateContexts {
    private static final StateContext<BoundedWindow> NULL_CONTEXT = new StateContext<BoundedWindow>(){

        @Override
        public PipelineOptions getPipelineOptions() {
            throw new IllegalArgumentException("cannot call getPipelineOptions() in a null context");
        }

        @Override
        public <T> T sideInput(PCollectionView<T> view) {
            throw new IllegalArgumentException("cannot call sideInput() in a null context");
        }

        @Override
        public BoundedWindow window() {
            throw new IllegalArgumentException("cannot call window() in a null context");
        }
    };

    public static <W extends BoundedWindow> StateContext<W> nullContext() {
        return NULL_CONTEXT;
    }

    public static <W extends BoundedWindow> StateContext<W> windowOnly(final W window) {
        return new StateContext<W>(){

            @Override
            public PipelineOptions getPipelineOptions() {
                throw new IllegalArgumentException("cannot call getPipelineOptions() in a window only context");
            }

            @Override
            public <T> T sideInput(PCollectionView<T> view) {
                throw new IllegalArgumentException("cannot call sideInput() in a window only context");
            }

            @Override
            public W window() {
                return window;
            }
        };
    }

    public static <W extends BoundedWindow> StateContext<W> createFromComponents(final @Nullable PipelineOptions options, final WindowingInternals<?, ?> windowingInternals, final W window) {
        StateContext<BoundedWindow> typedNullContext = NULL_CONTEXT;
        if (options == null) {
            return typedNullContext;
        }
        return new StateContext<W>(){

            @Override
            public PipelineOptions getPipelineOptions() {
                return options;
            }

            @Override
            public <T> T sideInput(PCollectionView<T> view) {
                return windowingInternals.sideInput(view, window);
            }

            @Override
            public W window() {
                return window;
            }
        };
    }
}

