/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.CombineWithContext;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFn;
import com.google.cloud.dataflow.sdk.util.state.AccumulatorCombiningState;
import com.google.cloud.dataflow.sdk.util.state.BagState;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import com.google.cloud.dataflow.sdk.util.state.WatermarkHoldState;
import java.io.IOException;
import java.io.Serializable;

@Experimental(value=Experimental.Kind.STATE)
public interface StateTag<K, StateT extends State>
extends Serializable {
    public void appendTo(Appendable var1) throws IOException;

    public String getId();

    public StateT bind(StateBinder<? extends K> var1);

    public static interface StateBinder<K> {
        public <T> ValueState<T> bindValue(StateTag<? super K, ValueState<T>> var1, Coder<T> var2);

        public <T> BagState<T> bindBag(StateTag<? super K, BagState<T>> var1, Coder<T> var2);

        public <InputT, AccumT, OutputT> AccumulatorCombiningState<InputT, AccumT, OutputT> bindCombiningValue(StateTag<? super K, AccumulatorCombiningState<InputT, AccumT, OutputT>> var1, Coder<AccumT> var2, Combine.CombineFn<InputT, AccumT, OutputT> var3);

        public <InputT, AccumT, OutputT> AccumulatorCombiningState<InputT, AccumT, OutputT> bindKeyedCombiningValue(StateTag<? super K, AccumulatorCombiningState<InputT, AccumT, OutputT>> var1, Coder<AccumT> var2, Combine.KeyedCombineFn<? super K, InputT, AccumT, OutputT> var3);

        public <InputT, AccumT, OutputT> AccumulatorCombiningState<InputT, AccumT, OutputT> bindKeyedCombiningValueWithContext(StateTag<? super K, AccumulatorCombiningState<InputT, AccumT, OutputT>> var1, Coder<AccumT> var2, CombineWithContext.KeyedCombineFnWithContext<? super K, InputT, AccumT, OutputT> var3);

        public <W extends BoundedWindow> WatermarkHoldState<W> bindWatermark(StateTag<? super K, WatermarkHoldState<W>> var1, OutputTimeFn<? super W> var2);
    }
}

