/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.values;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import com.google.cloud.dataflow.sdk.values.TypedPValue;

public class PCollection<T>
extends TypedPValue<T> {
    private WindowingStrategy<?, ?> windowingStrategy;
    private IsBounded isBounded;

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public PCollection<T> setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public Coder<T> getCoder() {
        return super.getCoder();
    }

    @Override
    public PCollection<T> setCoder(Coder<T> coder) {
        super.setCoder(coder);
        return this;
    }

    public <OutputT extends POutput> OutputT apply(PTransform<? super PCollection<T>, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<? super PCollection<T>, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    public WindowingStrategy<?, ?> getWindowingStrategy() {
        return this.windowingStrategy;
    }

    public IsBounded isBounded() {
        return this.isBounded;
    }

    private PCollection(Pipeline p) {
        super(p);
    }

    @Override
    public PCollection<T> setTypeDescriptorInternal(TypeDescriptor<T> typeDescriptor) {
        super.setTypeDescriptorInternal(typeDescriptor);
        return this;
    }

    public PCollection<T> setWindowingStrategyInternal(WindowingStrategy<?, ?> windowingStrategy) {
        this.windowingStrategy = windowingStrategy;
        return this;
    }

    public PCollection<T> setIsBoundedInternal(IsBounded isBounded) {
        this.isBounded = isBounded;
        return this;
    }

    public static <T> PCollection<T> createPrimitiveOutputInternal(Pipeline pipeline, WindowingStrategy<?, ?> windowingStrategy, IsBounded isBounded) {
        return new PCollection<T>(pipeline).setWindowingStrategyInternal(windowingStrategy).setIsBoundedInternal(isBounded);
    }

    public static enum IsBounded {
        BOUNDED,
        UNBOUNDED;


        public IsBounded and(IsBounded that) {
            if (this == BOUNDED && that == BOUNDED) {
                return BOUNDED;
            }
            return UNBOUNDED;
        }
    }
}

