/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.sink;

import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.sink.BigQuerySinkConfig;
import com.google.cloud.flink.bigquery.sink.serializer.BigQueryProtoSerializer;
import com.google.cloud.flink.bigquery.sink.serializer.BigQuerySchemaProvider;
import org.apache.flink.api.connector.sink2.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BigQueryBaseSink<IN>
implements Sink<IN> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAX_SINK_PARALLELISM = 128;
    final BigQueryConnectOptions connectOptions;
    final BigQuerySchemaProvider schemaProvider;
    final BigQueryProtoSerializer serializer;
    final String tablePath;

    BigQueryBaseSink(BigQuerySinkConfig sinkConfig) {
        this.validateSinkConfig(sinkConfig);
        this.connectOptions = sinkConfig.getConnectOptions();
        this.schemaProvider = sinkConfig.getSchemaProvider();
        this.serializer = sinkConfig.getSerializer();
        this.tablePath = String.format("projects/%s/datasets/%s/tables/%s", this.connectOptions.getProjectId(), this.connectOptions.getDataset(), this.connectOptions.getTable());
    }

    private void validateSinkConfig(BigQuerySinkConfig sinkConfig) {
        if (sinkConfig.getConnectOptions() == null) {
            throw new IllegalArgumentException("BigQuery connect options cannot be null");
        }
        if (sinkConfig.getSerializer() == null) {
            throw new IllegalArgumentException("BigQuery serializer cannot be null");
        }
        if (sinkConfig.getSchemaProvider() == null) {
            throw new IllegalArgumentException("BigQuery schema provider cannot be null");
        }
    }

    void checkParallelism(int numberOfParallelSubtasks) {
        if (numberOfParallelSubtasks > 128) {
            this.logger.error("Maximum allowed parallelism for Sink is {}, but attempting to create Writer number {}", (Object)128, (Object)numberOfParallelSubtasks);
            throw new IllegalStateException("Attempting to create more Sink Writers than allowed");
        }
    }
}

