/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.sink;

import com.google.cloud.flink.bigquery.sink.BigQueryDefaultSink;
import com.google.cloud.flink.bigquery.sink.BigQueryExactlyOnceSink;
import com.google.cloud.flink.bigquery.sink.BigQuerySinkConfig;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQuerySink {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySink.class);

    public static Sink get(BigQuerySinkConfig sinkConfig) {
        if (sinkConfig.getDeliveryGuarantee() == DeliveryGuarantee.AT_LEAST_ONCE) {
            return new BigQueryDefaultSink(sinkConfig);
        }
        if (sinkConfig.getDeliveryGuarantee() == DeliveryGuarantee.EXACTLY_ONCE) {
            return new BigQueryExactlyOnceSink(sinkConfig);
        }
        LOG.error("BigQuery sink does not support {} delivery guarantee. Use AT_LEAST_ONCE or EXACTLY_ONCE.", (Object)sinkConfig.getDeliveryGuarantee());
        throw new UnsupportedOperationException(String.format("%s is not supported", sinkConfig.getDeliveryGuarantee()));
    }
}

