/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.sink;

import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.sink.BigQuerySink;
import com.google.cloud.flink.bigquery.sink.serializer.BigQueryProtoSerializer;
import com.google.cloud.flink.bigquery.sink.serializer.BigQuerySchemaProvider;
import com.google.cloud.flink.bigquery.sink.serializer.BigQuerySchemaProviderImpl;
import com.google.cloud.flink.bigquery.sink.serializer.BigQueryTableSchemaProvider;
import com.google.cloud.flink.bigquery.sink.serializer.RowDataToProtoSerializer;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.types.logical.LogicalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQuerySinkConfig {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySink.class);
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private static final long MILLISECONDS_PER_HOUR = 3600000L;
    private final BigQueryConnectOptions connectOptions;
    private final DeliveryGuarantee deliveryGuarantee;
    private final BigQuerySchemaProvider schemaProvider;
    private final BigQueryProtoSerializer serializer;

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(this.connectOptions, this.deliveryGuarantee, this.schemaProvider, this.serializer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigQuerySinkConfig object = (BigQuerySinkConfig)obj;
        if (this.getConnectOptions() == object.getConnectOptions() && this.getSerializer().getClass() == object.getSerializer().getClass() && this.getDeliveryGuarantee() == object.getDeliveryGuarantee()) {
            BigQuerySchemaProvider thisSchemaProvider = this.getSchemaProvider();
            BigQuerySchemaProvider objSchemaProvider = object.getSchemaProvider();
            return thisSchemaProvider.getAvroSchema().equals((Object)objSchemaProvider.getAvroSchema());
        }
        return false;
    }

    private BigQuerySinkConfig(BigQueryConnectOptions connectOptions, DeliveryGuarantee deliveryGuarantee, BigQuerySchemaProvider schemaProvider, BigQueryProtoSerializer serializer) {
        this.connectOptions = connectOptions;
        this.deliveryGuarantee = deliveryGuarantee;
        this.schemaProvider = schemaProvider;
        this.serializer = serializer;
    }

    public BigQueryConnectOptions getConnectOptions() {
        return this.connectOptions;
    }

    public DeliveryGuarantee getDeliveryGuarantee() {
        return this.deliveryGuarantee;
    }

    public BigQueryProtoSerializer getSerializer() {
        return this.serializer;
    }

    public BigQuerySchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    @Internal
    public static BigQuerySinkConfig forTable(BigQueryConnectOptions connectOptions, DeliveryGuarantee deliveryGuarantee, LogicalType logicalType) {
        return new BigQuerySinkConfig(connectOptions, deliveryGuarantee, new BigQuerySchemaProviderImpl(BigQueryTableSchemaProvider.getAvroSchemaFromLogicalSchema(logicalType)), new RowDataToProtoSerializer());
    }

    public static void validateStreamExecutionEnvironment(StreamExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException("Expected StreamExecutionEnvironment, found null. Please provide the StreamExecutionEnvironment used in Flink job.");
        }
        BigQuerySinkConfig.validateRestartStrategy(env.getRestartStrategy());
    }

    private static void validateRestartStrategy(RestartStrategies.RestartStrategyConfiguration restartStrategy) {
        if (restartStrategy == null) {
            throw new IllegalArgumentException("Could not read RestartStrategyConfiguration from StreamExecutionEnvironment. Please provide the StreamExecutionEnvironment used in Flink job and set a restart strategy.");
        }
        if (restartStrategy instanceof RestartStrategies.FixedDelayRestartStrategyConfiguration) {
            RestartStrategies.FixedDelayRestartStrategyConfiguration strategy = (RestartStrategies.FixedDelayRestartStrategyConfiguration)restartStrategy;
            if (strategy.getDelayBetweenAttemptsInterval().toMilliseconds() < 1000L || strategy.getRestartAttempts() > 10) {
                LOG.error("Invalid FixedDelayRestartStrategyConfiguration: found restart delay {}, milliseconds, and {} restart attempts. Should be used with restart delay at least 1 second, and at most 10 restart attempts.", (Object)strategy.getDelayBetweenAttemptsInterval().toMilliseconds(), (Object)strategy.getRestartAttempts());
                throw new IllegalArgumentException("Invalid restart strategy: FixedDelayRestartStrategyConfiguration should be used with at least restart delay 1 second, and at most 10 restart attempts.");
            }
        } else if (restartStrategy instanceof RestartStrategies.ExponentialDelayRestartStrategyConfiguration) {
            RestartStrategies.ExponentialDelayRestartStrategyConfiguration strategy = (RestartStrategies.ExponentialDelayRestartStrategyConfiguration)restartStrategy;
            if (strategy.getBackoffMultiplier() < 2.0 || strategy.getInitialBackoff().toMilliseconds() < 1000L || strategy.getMaxBackoff().toMilliseconds() < 300000L || strategy.getResetBackoffThreshold().toMilliseconds() < 3600000L) {
                LOG.error("Invalid ExponentialDelayRestartStrategyConfiguration: found backoff multiplier {}, initial backoff {} milliseconds, maximum backoff {} milliseconds, and reset threshold {} milliseconds. Should be used with backoff multiplier at least 2, initial backoff at least 1 second, maximum backoff at least 5 minutes, and reset threshold at least 1 hour", new Object[]{strategy.getBackoffMultiplier(), strategy.getInitialBackoff().toMilliseconds(), strategy.getMaxBackoff().toMilliseconds(), strategy.getResetBackoffThreshold().toMilliseconds()});
                throw new IllegalArgumentException("Invalid restart strategy: ExponentialDelayRestartStrategyConfiguration should be used with backoff multiplier at least 2, initial backoff at least 1 second, maximum backoff at-least 5 minutes, and reset threshold at least 1 hour");
            }
        } else if (restartStrategy instanceof RestartStrategies.FailureRateRestartStrategyConfiguration) {
            RestartStrategies.FailureRateRestartStrategyConfiguration strategy = (RestartStrategies.FailureRateRestartStrategyConfiguration)restartStrategy;
            double failureIntervalInMinutes = (double)strategy.getFailureInterval().toMilliseconds() / 60000.0;
            double allowedFailuresPerMinute = (double)strategy.getMaxFailureRate() / failureIntervalInMinutes;
            if (strategy.getDelayBetweenAttemptsInterval().toMilliseconds() < 1000L || allowedFailuresPerMinute > 1.0) {
                LOG.error("Invalid FailureRateRestartStrategyConfiguration: found restart delay {} milliseconds, and allowed failure rate {} per minute. Should be used with restart delay at least 1 second, and allowed failure rate at most 1 per minute.", (Object)strategy.getDelayBetweenAttemptsInterval().toMilliseconds(), (Object)allowedFailuresPerMinute);
                throw new IllegalArgumentException("Invalid restart strategy: FailureRateRestartStrategyConfiguration should be used with restart delay at least 1 second, and allowed failure rate at most 1 per minute.");
            }
        } else if (restartStrategy instanceof RestartStrategies.NoRestartStrategyConfiguration) {
            LOG.debug("Found NoRestartStrategyConfiguration. No validation needed.");
        } else {
            LOG.warn("Cannot validate RestartStrategyConfiguration in StreamExecutionEnvironment. We recommend explicitly setting the restart strategy as one of the following: FixedDelayRestartStrategyConfiguration, ExponentialDelayRestartStrategyConfiguration, FailureRateRestartStrategyConfiguration or NoRestartStrategyConfiguration");
        }
    }

    public static class Builder {
        private BigQueryConnectOptions connectOptions;
        private DeliveryGuarantee deliveryGuarantee;
        private BigQuerySchemaProvider schemaProvider;
        private BigQueryProtoSerializer serializer;
        private StreamExecutionEnvironment env;

        public Builder connectOptions(BigQueryConnectOptions connectOptions) {
            this.connectOptions = connectOptions;
            return this;
        }

        public Builder deliveryGuarantee(DeliveryGuarantee deliveryGuarantee) {
            this.deliveryGuarantee = deliveryGuarantee;
            return this;
        }

        public Builder schemaProvider(BigQuerySchemaProvider schemaProvider) {
            this.schemaProvider = schemaProvider;
            return this;
        }

        public Builder serializer(BigQueryProtoSerializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder streamExecutionEnvironment(StreamExecutionEnvironment streamExecutionEnvironment) {
            this.env = streamExecutionEnvironment;
            return this;
        }

        public BigQuerySinkConfig build() {
            if (this.deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE) {
                BigQuerySinkConfig.validateStreamExecutionEnvironment(this.env);
            }
            return new BigQuerySinkConfig(this.connectOptions, this.deliveryGuarantee, this.schemaProvider, this.serializer);
        }
    }
}

