/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.sink.serializer;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaParseException;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaConvertor {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSchemaConvertor.class);
    private final ConcurrentMap<Schema, DataType> avroToDataTypeConversionMemorizationMap = new ConcurrentHashMap<Schema, DataType>();
    private final ConcurrentMap<org.apache.flink.table.types.logical.LogicalType, Schema> logicalToAvroTypeConversionMemorizationMap = new ConcurrentHashMap<org.apache.flink.table.types.logical.LogicalType, Schema>();

    public DataType convertToDataType(String avroSchemaString) {
        Schema schema;
        Preconditions.checkNotNull((Object)avroSchemaString, (String)"Avro schema must not be null.");
        try {
            schema = new Schema.Parser().parse(avroSchemaString);
        }
        catch (SchemaParseException e) {
            throw new IllegalArgumentException("Could not parse Avro schema string.", e);
        }
        return this.convertToDataType(schema);
    }

    private DataType convertToDataType(Schema schema) {
        DataType dataType;
        DataType convertedDataType = this.getFromAvroToDataTypeConversionMap(schema);
        if (convertedDataType != null) {
            return convertedDataType;
        }
        switch (schema.getType()) {
            case RECORD: {
                List schemaFields = schema.getFields();
                DataTypes.Field[] fields = new DataTypes.Field[schemaFields.size()];
                for (int i = 0; i < schemaFields.size(); ++i) {
                    Schema.Field field = (Schema.Field)schemaFields.get(i);
                    fields[i] = DataTypes.FIELD((String)field.name(), (DataType)this.convertToDataType(field.schema()));
                }
                dataType = (DataType)DataTypes.ROW((DataTypes.Field[])fields).notNull();
                break;
            }
            case ARRAY: {
                dataType = (DataType)DataTypes.ARRAY((DataType)this.convertToDataType(schema.getElementType())).notNull();
                break;
            }
            case UNION: {
                boolean nullable;
                Schema actualSchema;
                if (schema.getTypes().size() == 2 && (((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL || ((Schema)schema.getTypes().get(1)).getType() == Schema.Type.NULL)) {
                    actualSchema = ((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL ? (Schema)schema.getTypes().get(1) : (Schema)schema.getTypes().get(0);
                    nullable = true;
                } else if (schema.getTypes().size() == 1) {
                    actualSchema = (Schema)schema.getTypes().get(0);
                    nullable = false;
                } else {
                    return new AtomicDataType((org.apache.flink.table.types.logical.LogicalType)new TypeInformationRawType(false, Types.GENERIC(Object.class)));
                }
                DataType converted = this.convertToDataType(actualSchema);
                dataType = nullable ? (DataType)converted.nullable() : converted;
                break;
            }
            case MAP: {
                dataType = (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().notNull()), (DataType)this.convertToDataType(schema.getValueType())).notNull();
                break;
            }
            case STRING: {
                DataType logicalDataType = AvroSchemaConvertor.handleLogicalTypeSchema(schema);
                if (logicalDataType != null) {
                    return logicalDataType;
                }
                dataType = (DataType)DataTypes.STRING().notNull();
                break;
            }
            case ENUM: {
                dataType = (DataType)DataTypes.STRING().notNull();
                break;
            }
            case FIXED: {
                DataType logicalDataType = AvroSchemaConvertor.handleLogicalTypeSchema(schema);
                if (logicalDataType != null) {
                    this.addToAvroToDataTypeConversionMap(schema, logicalDataType);
                    return logicalDataType;
                }
                dataType = (DataType)DataTypes.VARBINARY((int)schema.getFixedSize()).notNull();
                break;
            }
            case BYTES: {
                DataType logicalDataType = AvroSchemaConvertor.handleLogicalTypeSchema(schema);
                if (logicalDataType != null) {
                    this.addToAvroToDataTypeConversionMap(schema, logicalDataType);
                    return logicalDataType;
                }
                dataType = (DataType)DataTypes.BYTES().notNull();
                break;
            }
            case INT: {
                DataType logicalDataType = AvroSchemaConvertor.handleLogicalTypeSchema(schema);
                if (logicalDataType != null) {
                    this.addToAvroToDataTypeConversionMap(schema, logicalDataType);
                    return logicalDataType;
                }
                dataType = (DataType)DataTypes.INT().notNull();
                break;
            }
            case LONG: {
                DataType logicalDataType = AvroSchemaConvertor.handleLogicalTypeSchema(schema);
                if (logicalDataType != null) {
                    this.addToAvroToDataTypeConversionMap(schema, logicalDataType);
                    return logicalDataType;
                }
                dataType = (DataType)DataTypes.BIGINT().notNull();
                break;
            }
            case FLOAT: {
                dataType = (DataType)DataTypes.FLOAT().notNull();
                break;
            }
            case DOUBLE: {
                dataType = (DataType)DataTypes.DOUBLE().notNull();
                break;
            }
            case BOOLEAN: {
                dataType = (DataType)DataTypes.BOOLEAN().notNull();
                break;
            }
            case NULL: {
                dataType = DataTypes.NULL();
                break;
            }
            default: {
                LOG.info("Unsupported Avro type '" + schema.getType() + "'. \nSupported types are NULL, BOOLEAN, DOUBLE, FLOAT, LONG, INT, BYTES, FIXED, ENUM, STRING, ENUM, MAP, UNION, ARRAY, RECORD ");
                throw new IllegalArgumentException("Unsupported Avro type '" + schema.getType() + "'.");
            }
        }
        this.addToAvroToDataTypeConversionMap(schema, dataType);
        return dataType;
    }

    private void addToAvroToDataTypeConversionMap(Schema schema, DataType dataType) {
        this.avroToDataTypeConversionMemorizationMap.putIfAbsent(schema, dataType);
    }

    @Nullable
    private DataType getFromAvroToDataTypeConversionMap(Schema schema) {
        return this.avroToDataTypeConversionMemorizationMap.getOrDefault(schema, null);
    }

    private static DataType handleLogicalTypeSchema(Schema fieldSchema) {
        String logicalTypeString = fieldSchema.getProp("logicalType");
        if (logicalTypeString != null) {
            if (logicalTypeString.equals(LogicalTypes.date().getName())) {
                return (DataType)DataTypes.DATE().notNull();
            }
            if (logicalTypeString.equals(LogicalTypes.decimal((int)1).getName())) {
                LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)fieldSchema.getLogicalType();
                int precision = decimalType.getPrecision();
                if (fieldSchema.getObjectProp("isNumeric") != null && precision < 39 && precision > 0) {
                    return (DataType)DataTypes.DECIMAL((int)precision, (int)decimalType.getScale()).notNull();
                }
                return (DataType)DataTypes.BYTES().notNull();
            }
            if (logicalTypeString.equals(LogicalTypes.timestampMicros().getName())) {
                return (DataType)DataTypes.TIMESTAMP((int)6).notNull();
            }
            if (logicalTypeString.equals(LogicalTypes.timestampMillis().getName())) {
                return (DataType)DataTypes.TIMESTAMP((int)3).notNull();
            }
            if (logicalTypeString.equals(LogicalTypes.uuid().getName())) {
                return (DataType)DataTypes.STRING().notNull();
            }
            if (logicalTypeString.equals(LogicalTypes.timeMillis().getName())) {
                return (DataType)DataTypes.TIME((int)3).notNull();
            }
            if (logicalTypeString.equals(LogicalTypes.timeMicros().getName())) {
                return (DataType)DataTypes.TIME((int)6).notNull();
            }
            if (logicalTypeString.equals(LogicalTypes.localTimestampMillis().getName())) {
                return (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull();
            }
            if (logicalTypeString.equals(LogicalTypes.localTimestampMicros().getName())) {
                return (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE().notNull();
            }
            if (logicalTypeString.equals("geography_wkt") || logicalTypeString.equals("Json")) {
                return (DataType)DataTypes.STRING().notNull();
            }
        }
        return null;
    }

    public Schema convertToSchema(org.apache.flink.table.types.logical.LogicalType schema) {
        return this.convertToSchema(schema, "org.apache.flink.avro.generated.record");
    }

    public Schema convertToSchema(org.apache.flink.table.types.logical.LogicalType logicalType, String rowName) {
        Schema avroSchema;
        Schema convertedSchema = this.getFromLogicalToAvroTypeConversionMap(logicalType);
        if (convertedSchema != null) {
            return convertedSchema;
        }
        boolean nullable = logicalType.isNullable();
        switch (logicalType.getTypeRoot()) {
            case NULL: {
                avroSchema = (Schema)SchemaBuilder.builder().nullType();
                break;
            }
            case BOOLEAN: {
                Schema booleanType = (Schema)SchemaBuilder.builder().booleanType();
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(booleanType) : booleanType;
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                Schema intType = (Schema)SchemaBuilder.builder().intType();
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(intType) : intType;
                break;
            }
            case BIGINT: {
                Schema longType = (Schema)SchemaBuilder.builder().longType();
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(longType) : longType;
                break;
            }
            case FLOAT: {
                Schema floatType = (Schema)SchemaBuilder.builder().floatType();
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(floatType) : floatType;
                break;
            }
            case DOUBLE: {
                Schema doubleType = (Schema)SchemaBuilder.builder().doubleType();
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(doubleType) : doubleType;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                Schema stringType = (Schema)SchemaBuilder.builder().stringType();
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(stringType) : stringType;
                break;
            }
            case BINARY: 
            case VARBINARY: {
                Schema binaryType = (Schema)SchemaBuilder.builder().bytesType();
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(binaryType) : binaryType;
                break;
            }
            case DATE: {
                Schema dateType = LogicalTypes.date().addToSchema((Schema)SchemaBuilder.builder().intType());
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(dateType) : dateType;
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case TIME_WITHOUT_TIME_ZONE: {
                Schema schema = AvroSchemaConvertor.getAvroLogicalType(logicalType);
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(schema) : schema;
                break;
            }
            case DECIMAL: {
                Schema decimalSchema = AvroSchemaConvertor.getDecimalSchema(logicalType);
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(decimalSchema) : decimalSchema;
                break;
            }
            case ROW: {
                Schema rowSchema = this.getRowSchema(logicalType, rowName);
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(rowSchema) : rowSchema;
                break;
            }
            case MULTISET: 
            case MAP: {
                Schema mapType = (Schema)SchemaBuilder.builder().map().values(this.convertToSchema(AvroSchemaConvertor.extractValueTypeToAvroMap(logicalType), rowName));
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(mapType) : mapType;
                break;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)logicalType;
                Schema array = (Schema)SchemaBuilder.builder().array().items(this.convertToSchema(arrayType.getElementType(), rowName));
                avroSchema = nullable ? AvroSchemaConvertor.nullableSchema(array) : array;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported to derive Schema for type: " + logicalType);
            }
        }
        this.addToLogicalToAvroTypeConversionMap(logicalType, avroSchema);
        return avroSchema;
    }

    private Schema getRowSchema(org.apache.flink.table.types.logical.LogicalType logicalType, String rowName) {
        RowType rowType = (RowType)logicalType;
        SchemaBuilder.FieldAssembler builder = SchemaBuilder.builder().record(rowName).fields();
        for (RowType.RowField field : rowType.getFields()) {
            String fieldName = field.getName();
            org.apache.flink.table.types.logical.LogicalType fieldType = field.getType();
            SchemaBuilder.GenericDefault fieldBuilder = builder.name(fieldName).type(this.convertToSchema(fieldType, rowName + "_" + fieldName));
            builder = fieldBuilder.noDefault();
        }
        return (Schema)builder.endRecord();
    }

    private static Schema getDecimalSchema(org.apache.flink.table.types.logical.LogicalType logicalType) {
        DecimalType decimalType = (DecimalType)logicalType;
        int precision = decimalType.getPrecision();
        Schema decimal = LogicalTypes.decimal((int)precision, (int)decimalType.getScale()).addToSchema((Schema)SchemaBuilder.builder().bytesType());
        if (precision <= 38 && precision > 0) {
            decimal.addProp("isNumeric", (Object)true);
        }
        return decimal;
    }

    private static Schema getAvroLogicalType(org.apache.flink.table.types.logical.LogicalType logicalType) {
        if (logicalType instanceof TimestampType) {
            int precision = ((TimestampType)logicalType).getPrecision();
            LogicalType avroLogicalType = AvroSchemaConvertor.getAvroLogicalTimestampType(precision);
            return avroLogicalType.addToSchema((Schema)SchemaBuilder.builder().longType());
        }
        if (logicalType instanceof TimeType) {
            int precision = ((TimeType)logicalType).getPrecision();
            return AvroSchemaConvertor.getTimeType(precision);
        }
        if (logicalType instanceof LocalZonedTimestampType) {
            int precision = ((LocalZonedTimestampType)logicalType).getPrecision();
            LogicalType avroLogicalDateTimeType = AvroSchemaConvertor.getAvroLogicalDateTimeType(precision);
            return avroLogicalDateTimeType.addToSchema((Schema)SchemaBuilder.builder().longType());
        }
        throw new IllegalArgumentException("Invalid logical type obtained!. Cannot convert.");
    }

    private static LogicalType getAvroLogicalDateTimeType(int precision) {
        LogicalTypes.LocalTimestampMillis avroLogicalDateTimeType;
        if (precision <= 3) {
            avroLogicalDateTimeType = LogicalTypes.localTimestampMillis();
        } else if (precision <= 6) {
            avroLogicalDateTimeType = LogicalTypes.localTimestampMicros();
        } else {
            throw new IllegalArgumentException("Avro does not support DATETIME type with precision: " + precision + ", it only supports precision less than equal to 6.");
        }
        return avroLogicalDateTimeType;
    }

    private static LogicalType getAvroLogicalTimestampType(int precision) {
        LogicalTypes.TimestampMillis avroLogicalType;
        if (precision <= 3) {
            avroLogicalType = LogicalTypes.timestampMillis();
        } else if (precision <= 6) {
            avroLogicalType = LogicalTypes.timestampMicros();
        } else {
            throw new IllegalArgumentException("Avro does not support TIMESTAMP type with precision: " + precision + ", it only supports precision less than equal to 6.");
        }
        return avroLogicalType;
    }

    private static Schema getTimeType(int precision) {
        Schema avroSchemaTimeType;
        LogicalTypes.TimeMillis avroLogicalTimeType;
        if (precision <= 3) {
            avroLogicalTimeType = LogicalTypes.timeMillis();
            avroSchemaTimeType = (Schema)SchemaBuilder.builder().intType();
        } else if (precision <= 6) {
            avroLogicalTimeType = LogicalTypes.timeMicros();
            avroSchemaTimeType = (Schema)SchemaBuilder.builder().longType();
        } else {
            throw new IllegalArgumentException("Avro does not support TIME type with precision: " + precision + ", it only supports precision less than equal to 6.");
        }
        return avroLogicalTimeType.addToSchema(avroSchemaTimeType);
    }

    public static org.apache.flink.table.types.logical.LogicalType extractValueTypeToAvroMap(org.apache.flink.table.types.logical.LogicalType type) {
        org.apache.flink.table.types.logical.LogicalType valueType;
        org.apache.flink.table.types.logical.LogicalType keyType;
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            keyType = mapType.getKeyType();
            valueType = mapType.getValueType();
        } else {
            MultisetType multisetType = (MultisetType)type;
            keyType = multisetType.getElementType();
            valueType = new IntType();
        }
        if (!keyType.is(LogicalTypeFamily.CHARACTER_STRING)) {
            throw new UnsupportedOperationException("Avro format doesn't support non-string as key type of map. The key type is: " + keyType.asSummaryString());
        }
        return valueType;
    }

    @Nullable
    private Schema getFromLogicalToAvroTypeConversionMap(org.apache.flink.table.types.logical.LogicalType logicalType) {
        return this.logicalToAvroTypeConversionMemorizationMap.getOrDefault(logicalType, null);
    }

    private void addToLogicalToAvroTypeConversionMap(org.apache.flink.table.types.logical.LogicalType logicalType, Schema schema) {
        this.logicalToAvroTypeConversionMemorizationMap.putIfAbsent(logicalType, schema);
    }

    private static Schema nullableSchema(Schema schema) {
        return schema.isNullable() ? schema : Schema.createUnion((Schema[])new Schema[]{(Schema)SchemaBuilder.builder().nullType(), schema});
    }
}

