/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.sink.serializer;

import com.google.api.client.util.Preconditions;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.common.exceptions.BigQueryConnectorException;
import com.google.cloud.flink.bigquery.common.utils.SchemaTransform;
import com.google.cloud.flink.bigquery.services.BigQueryServices;
import com.google.cloud.flink.bigquery.services.BigQueryServicesFactory;
import com.google.cloud.flink.bigquery.services.BigQueryUtils;
import com.google.cloud.flink.bigquery.sink.serializer.AvroToProtoSerializer;
import com.google.cloud.flink.bigquery.sink.serializer.BigQuerySchemaProvider;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class BigQuerySchemaProviderImpl
implements BigQuerySchemaProvider {
    private final Schema avroSchema;
    private final DescriptorProtos.DescriptorProto descriptorProto;
    private static final Map<Schema.Type, DescriptorProtos.FieldDescriptorProto.Type> AVRO_TYPES_TO_PROTO = new EnumMap<Schema.Type, DescriptorProtos.FieldDescriptorProto.Type>(Schema.Type.class);
    private static final Map<String, DescriptorProtos.FieldDescriptorProto.Type> LOGICAL_AVRO_TYPES_TO_PROTO;

    public BigQuerySchemaProviderImpl(BigQueryConnectOptions connectOptions) {
        this(BigQuerySchemaProviderImpl.getTableSchemaFromOptions(connectOptions));
    }

    public BigQuerySchemaProviderImpl(TableSchema tableSchema) {
        this(BigQuerySchemaProviderImpl.getAvroSchema(tableSchema));
    }

    public BigQuerySchemaProviderImpl(Schema avroSchema) {
        this.avroSchema = avroSchema;
        this.descriptorProto = BigQuerySchemaProviderImpl.getDescriptorSchemaFromAvroSchema(this.avroSchema);
    }

    @Override
    public DescriptorProtos.DescriptorProto getDescriptorProto() {
        return this.descriptorProto;
    }

    @Override
    public Descriptors.Descriptor getDescriptor() {
        try {
            return BigQuerySchemaProviderImpl.getDescriptorFromDescriptorProto(this.descriptorProto);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new BigQueryConnectorException(String.format("Could not obtain Descriptor from Descriptor Proto.%nError: %s", e.getMessage()), e.getCause());
        }
    }

    @Override
    public Schema getAvroSchema() {
        return this.avroSchema;
    }

    static TableSchema getTableSchemaFromOptions(BigQueryConnectOptions connectOptions) {
        BigQueryServices.QueryDataClient queryDataClient = BigQueryServicesFactory.instance((BigQueryConnectOptions)connectOptions).queryClient();
        return queryDataClient.getTableSchema(connectOptions.getProjectId(), connectOptions.getDataset(), connectOptions.getTable());
    }

    static Schema getAvroSchema(TableSchema tableSchema) {
        return SchemaTransform.toGenericAvroSchema((String)"root", (List)tableSchema.getFields());
    }

    private static DescriptorProtos.DescriptorProto getDescriptorSchemaFromAvroSchema(Schema schema) {
        Preconditions.checkState((!schema.getFields().isEmpty() ? 1 : 0) != 0);
        DescriptorProtos.DescriptorProto.Builder descriptorBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        descriptorBuilder.setName(BigQueryUtils.bqSanitizedRandomUUIDForDescriptor());
        int i = 1;
        for (Schema.Field field : schema.getFields()) {
            BigQuerySchemaProviderImpl.fieldDescriptorFromSchemaField(field, i++, descriptorBuilder);
        }
        return descriptorBuilder.build();
    }

    private static void fieldDescriptorFromSchemaField(Schema.Field field, int fieldNumber, DescriptorProtos.DescriptorProto.Builder descriptorProtoBuilder) {
        Schema schema = field.schema();
        Preconditions.checkNotNull((Object)schema, (Object)"Unexpected null schema!");
        DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(field.name().toLowerCase()).setNumber(fieldNumber);
        boolean isNullable = false;
        switch (schema.getType()) {
            case RECORD: {
                Preconditions.checkState((!schema.getFields().isEmpty() ? 1 : 0) != 0);
                DescriptorProtos.DescriptorProto nested = BigQuerySchemaProviderImpl.getDescriptorSchemaFromAvroSchema(schema);
                descriptorProtoBuilder.addNestedType(nested);
                fieldDescriptorBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setTypeName(nested.getName());
                break;
            }
            case ARRAY: {
                fieldDescriptorBuilder = BigQuerySchemaProviderImpl.getDescriptorProtoForArraySchema(schema, field, fieldNumber, descriptorProtoBuilder);
                break;
            }
            case MAP: {
                throw new UnsupportedOperationException("MAP type not supported yet.");
            }
            case UNION: {
                ImmutablePair<Schema, Boolean> handleUnionSchemaResult = AvroToProtoSerializer.AvroSchemaHandler.handleUnionSchema(schema);
                schema = (Schema)handleUnionSchemaResult.getLeft();
                isNullable = (Boolean)handleUnionSchemaResult.getRight();
                fieldDescriptorBuilder = BigQuerySchemaProviderImpl.getDescriptorProtoForUnionSchema(schema, isNullable, field, fieldNumber, descriptorProtoBuilder);
                break;
            }
            default: {
                BigQuerySchemaProviderImpl.getDescriptorProtoForPrimitiveAndLogicalSchema(schema, fieldDescriptorBuilder, field);
            }
        }
        if (fieldDescriptorBuilder.getLabel() != DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED) {
            if (isNullable) {
                fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
            } else {
                fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
            }
        }
        descriptorProtoBuilder.addField(fieldDescriptorBuilder.build());
    }

    private static DescriptorProtos.FieldDescriptorProto.Builder getDescriptorProtoForUnionSchema(Schema elementType, boolean isNullable, Schema.Field field, int fieldNumber, DescriptorProtos.DescriptorProto.Builder descriptorProtoBuilder) throws IllegalArgumentException, UnsupportedOperationException {
        if (elementType == null) {
            throw new IllegalArgumentException("Unexpected null element type!");
        }
        if (isNullable && (elementType.getType() == Schema.Type.MAP || elementType.getType() == Schema.Type.ARRAY)) {
            throw new UnsupportedOperationException("NULLABLE MAP/ARRAYS in UNION types are not supported");
        }
        DescriptorProtos.DescriptorProto.Builder unionFieldBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        BigQuerySchemaProviderImpl.fieldDescriptorFromSchemaField(new Schema.Field(field.name(), elementType, field.doc(), field.defaultVal()), fieldNumber, unionFieldBuilder);
        descriptorProtoBuilder.addAllNestedType((Iterable)unionFieldBuilder.getNestedTypeList());
        return unionFieldBuilder.getFieldBuilder(0);
    }

    private static void getDescriptorProtoForPrimitiveAndLogicalSchema(Schema elementType, DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorBuilder, Schema.Field field) throws UnsupportedOperationException {
        DescriptorProtos.FieldDescriptorProto.Type type = Optional.ofNullable(elementType.getProp("logicalType")).map(LOGICAL_AVRO_TYPES_TO_PROTO::get).orElse(AVRO_TYPES_TO_PROTO.get(elementType.getType()));
        if (type == null) {
            throw new UnsupportedOperationException("Converting AVRO type " + elementType.getType() + " to Storage API Proto type is unsupported");
        }
        fieldDescriptorBuilder.setType(type);
        if (field.hasDefaultValue()) {
            fieldDescriptorBuilder.setDefaultValue(field.defaultVal().toString());
        }
    }

    private static DescriptorProtos.FieldDescriptorProto.Builder getDescriptorProtoForArraySchema(Schema avroSchema, Schema.Field field, Integer fieldNumber, DescriptorProtos.DescriptorProto.Builder descriptorProtoBuilder) throws UnsupportedOperationException {
        Schema elementType = avroSchema.getElementType();
        if (elementType == null) {
            throw new IllegalArgumentException("Unexpected null element type!");
        }
        Preconditions.checkState((elementType.getType() != Schema.Type.ARRAY ? 1 : 0) != 0, (Object)"Nested arrays not supported by BigQuery.");
        if (elementType.getType() == Schema.Type.MAP) {
            throw new UnsupportedOperationException("Array of Type MAP not supported yet.");
        }
        DescriptorProtos.DescriptorProto.Builder arrayFieldBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        BigQuerySchemaProviderImpl.fieldDescriptorFromSchemaField(new Schema.Field(field.name(), elementType, field.doc(), field.defaultVal()), fieldNumber, arrayFieldBuilder);
        DescriptorProtos.FieldDescriptorProto.Builder arrayFieldElementBuilder = arrayFieldBuilder.getFieldBuilder(0);
        if (arrayFieldElementBuilder.getLabel() != DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED) {
            throw new IllegalArgumentException("Array cannot have a NULLABLE element");
        }
        descriptorProtoBuilder.addAllNestedType((Iterable)arrayFieldBuilder.getNestedTypeList());
        return arrayFieldElementBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED).clearDefaultValue();
    }

    private static Descriptors.Descriptor getDescriptorFromDescriptorProto(DescriptorProtos.DescriptorProto descriptorProto) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        List descriptorTypeList = fileDescriptor.getMessageTypes();
        if (descriptorTypeList.size() == 1) {
            return (Descriptors.Descriptor)descriptorTypeList.get(0);
        }
        throw new IllegalArgumentException(String.format("Expected one element but was %s", descriptorTypeList));
    }

    static {
        AVRO_TYPES_TO_PROTO.put(Schema.Type.INT, DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32);
        AVRO_TYPES_TO_PROTO.put(Schema.Type.FIXED, DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES);
        AVRO_TYPES_TO_PROTO.put(Schema.Type.LONG, DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
        AVRO_TYPES_TO_PROTO.put(Schema.Type.FLOAT, DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT);
        AVRO_TYPES_TO_PROTO.put(Schema.Type.DOUBLE, DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE);
        AVRO_TYPES_TO_PROTO.put(Schema.Type.STRING, DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        AVRO_TYPES_TO_PROTO.put(Schema.Type.BOOLEAN, DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL);
        AVRO_TYPES_TO_PROTO.put(Schema.Type.ENUM, DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        AVRO_TYPES_TO_PROTO.put(Schema.Type.BYTES, DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES);
        LOGICAL_AVRO_TYPES_TO_PROTO = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Type>();
        LOGICAL_AVRO_TYPES_TO_PROTO.put(LogicalTypes.date().getName(), DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32);
        LOGICAL_AVRO_TYPES_TO_PROTO.put(LogicalTypes.decimal((int)1).getName(), DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES);
        LOGICAL_AVRO_TYPES_TO_PROTO.put(LogicalTypes.timestampMicros().getName(), DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
        LOGICAL_AVRO_TYPES_TO_PROTO.put(LogicalTypes.timestampMillis().getName(), DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
        LOGICAL_AVRO_TYPES_TO_PROTO.put(LogicalTypes.uuid().getName(), DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        LOGICAL_AVRO_TYPES_TO_PROTO.put(LogicalTypes.timeMillis().getName(), DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        LOGICAL_AVRO_TYPES_TO_PROTO.put(LogicalTypes.timeMicros().getName(), DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        LOGICAL_AVRO_TYPES_TO_PROTO.put(LogicalTypes.localTimestampMillis().getName(), DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        LOGICAL_AVRO_TYPES_TO_PROTO.put(LogicalTypes.localTimestampMicros().getName(), DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        LOGICAL_AVRO_TYPES_TO_PROTO.put("geography_wkt", DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        LOGICAL_AVRO_TYPES_TO_PROTO.put("Json", DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
    }
}

