/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.sink.serializer;

import com.google.api.client.util.Preconditions;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.common.config.CredentialsOptions;
import com.google.cloud.flink.bigquery.services.BigQueryServices;
import com.google.cloud.flink.bigquery.sink.serializer.AvroSchemaConvertor;
import com.google.cloud.flink.bigquery.sink.serializer.BigQuerySchemaProviderImpl;
import com.google.cloud.flink.bigquery.table.config.BigQueryTableConfig;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.function.SerializableSupplier;

public class BigQueryTableSchemaProvider {
    private static SerializableSupplier<BigQueryServices> testingServices = null;

    private BigQueryTableSchemaProvider() {
    }

    public static void setTestingServices(SerializableSupplier<BigQueryServices> testingServices) {
        BigQueryTableSchemaProvider.testingServices = testingServices;
    }

    private static BigQueryConnectOptions getConnectOptionsFromTableConfig(BigQueryTableConfig tableConfig) throws IOException {
        return BigQueryConnectOptions.builder().setTable(tableConfig.getTable()).setProjectId(tableConfig.getProject()).setDataset(tableConfig.getDataset()).setTestingBigQueryServices(testingServices).setCredentialsOptions(CredentialsOptions.builder().setAccessToken(tableConfig.getCredentialAccessToken()).setCredentialsFile(tableConfig.getCredentialFile()).setCredentialsKey(tableConfig.getCredentialKey()).build()).build();
    }

    public static DataType getDataTypeSchemaFromAvroSchema(Schema avroSchema) {
        AvroSchemaConvertor avroSchemaConvertor = new AvroSchemaConvertor();
        return avroSchemaConvertor.convertToDataType(avroSchema.toString());
    }

    public static Schema getAvroSchemaFromLogicalSchema(LogicalType logicalType) {
        AvroSchemaConvertor avroSchemaConvertor = new AvroSchemaConvertor();
        return avroSchemaConvertor.convertToSchema(logicalType);
    }

    private static org.apache.flink.table.api.Schema getTableApiSchemaFromAvroSchema(Schema avroSchema) {
        Preconditions.checkNotNull((Object)avroSchema, (Object)"Avro Schema not initialized before obtaining Table API Schema.");
        DataType dataTypeSchema = BigQueryTableSchemaProvider.getDataTypeSchemaFromAvroSchema(avroSchema);
        return org.apache.flink.table.api.Schema.newBuilder().fromRowDataType(dataTypeSchema).build();
    }

    public static TableDescriptor getTableDescriptor(BigQueryTableConfig tableConfig) throws IOException {
        BigQueryConnectOptions connectOptions = BigQueryTableSchemaProvider.getConnectOptionsFromTableConfig(tableConfig);
        TableSchema bigQueryTableSchema = BigQuerySchemaProviderImpl.getTableSchemaFromOptions(connectOptions);
        Schema avroSchema = BigQuerySchemaProviderImpl.getAvroSchema(bigQueryTableSchema);
        org.apache.flink.table.api.Schema tableApiSchema = BigQueryTableSchemaProvider.getTableApiSchemaFromAvroSchema(avroSchema);
        TableDescriptor tableDescriptor = TableDescriptor.forConnector((String)"bigquery").schema(tableApiSchema).build();
        return tableConfig.updateTableDescriptor(tableDescriptor);
    }
}

