/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.sink.serializer;

import com.google.api.client.util.Preconditions;
import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.cloud.flink.bigquery.sink.exceptions.BigQuerySerializationException;
import com.google.cloud.flink.bigquery.sink.serializer.AvroToProtoSerializer;
import com.google.cloud.flink.bigquery.sink.serializer.BigQueryProtoSerializer;
import com.google.cloud.flink.bigquery.sink.serializer.BigQuerySchemaProvider;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowDataToProtoSerializer
extends BigQueryProtoSerializer<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(RowDataToProtoSerializer.class);
    private Descriptors.Descriptor descriptor;
    private LogicalType type;

    @Override
    public void init(BigQuerySchemaProvider bigQuerySchemaProvider) {
        Preconditions.checkNotNull((Object)bigQuerySchemaProvider, (Object)"BigQuerySchemaProvider not found while initializing AvroToProtoSerializer");
        Descriptors.Descriptor derivedDescriptor = bigQuerySchemaProvider.getDescriptor();
        Preconditions.checkNotNull((Object)derivedDescriptor, (Object)"Destination BigQuery table's Proto Schema could not be found.");
        this.descriptor = derivedDescriptor;
    }

    public void setLogicalType(LogicalType type) {
        this.type = type;
    }

    @Override
    public ByteString serialize(RowData record) throws BigQuerySerializationException {
        try {
            return this.getDynamicMessageFromRowData(record, this.descriptor, this.type).toByteString();
        }
        catch (Exception e) {
            throw new BigQuerySerializationException(String.format("Error while serialising Row Data record: %s%nError: %s", record, e.getMessage()), e);
        }
    }

    public Object toProtoValue(LogicalType fieldType, int fieldNumber, RowData element, Descriptors.FieldDescriptor fieldDescriptor) {
        try {
            switch (fieldType.getTypeRoot()) {
                case CHAR: 
                case VARCHAR: {
                    return element.getString(fieldNumber).toString();
                }
                case BOOLEAN: {
                    return element.getBoolean(fieldNumber);
                }
                case BINARY: 
                case VARBINARY: {
                    return ByteString.copyFrom((byte[])element.getBinary(fieldNumber));
                }
                case DECIMAL: {
                    DecimalType decimalType = (DecimalType)fieldType;
                    int precision = decimalType.getPrecision();
                    int scale = decimalType.getScale();
                    BigDecimal decimalValue = element.getDecimal(fieldNumber, precision, scale).toBigDecimal();
                    return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)decimalValue);
                }
                case TINYINT: 
                case SMALLINT: {
                    return (int)element.getShort(fieldNumber);
                }
                case INTEGER: 
                case DATE: {
                    return element.getInt(fieldNumber);
                }
                case BIGINT: {
                    return element.getLong(fieldNumber);
                }
                case FLOAT: {
                    return Float.valueOf(element.getFloat(fieldNumber));
                }
                case DOUBLE: {
                    return element.getDouble(fieldNumber);
                }
                case ROW: {
                    RowData row = element.getRow(fieldNumber, fieldType.getChildren().size());
                    return this.getDynamicMessageFromRowData(row, fieldDescriptor.getMessageType(), fieldType);
                }
                case TIME_WITHOUT_TIME_ZONE: {
                    if (((TimeType)fieldType).getPrecision() == 3) {
                        return AvroToProtoSerializer.AvroSchemaHandler.convertTime(element.getInt(fieldNumber), false);
                    }
                    return AvroToProtoSerializer.AvroSchemaHandler.convertTime(element.getLong(fieldNumber), true);
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    if (((TimestampType)fieldType).getPrecision() == 3) {
                        return AvroToProtoSerializer.AvroSchemaHandler.convertTimestamp(element.getTimestamp(fieldNumber, 3).getMillisecond(), false, "Timestamp(millis)");
                    }
                    TimestampData timestampData = element.getTimestamp(fieldNumber, 6);
                    long micros = this.getMicrosFromTsData(timestampData);
                    return AvroToProtoSerializer.AvroSchemaHandler.convertTimestamp(micros, true, "Timestamp(micros)");
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    if (((LocalZonedTimestampType)fieldType).getPrecision() == 3) {
                        return AvroToProtoSerializer.AvroSchemaHandler.convertDateTime(element.getTimestamp(fieldNumber, 3).getMillisecond(), false);
                    }
                    TimestampData timestampData = element.getTimestamp(fieldNumber, 6);
                    long micros = this.getMicrosFromTsData(timestampData);
                    return AvroToProtoSerializer.AvroSchemaHandler.convertDateTime(micros, true);
                }
                case ARRAY: {
                    LogicalType arrayElementType = RowDataToProtoSerializer.getArrayElementType(fieldType);
                    ArrayData.ElementGetter elementGetter = ArrayData.createElementGetter((LogicalType)arrayElementType);
                    return Stream.iterate(0, pos -> pos + 1).limit(element.getArray(fieldNumber).size()).map(pos -> this.convertArrayElement(elementGetter, element, fieldNumber, (int)pos, arrayElementType, fieldDescriptor)).collect(Collectors.toList());
                }
            }
            String notSupportedError = String.format("Serialization to ByteString for the passed RowData type: '%s' is not supported yet!", fieldType.getTypeRoot().toString());
            LOG.error(String.format("%s%nSupported types are: %s.", notSupportedError, "CHAR, VARCHAR, BOOLEAN, BINARY, VARBINARY, DECIMAL, TINYINT, SMALLINT, INTEGER, DATE, BIGINT, FLOAT, DOUBLE, ROW, TIME_WITHOUT_TIME_ZONE, TIMESTAMP_WITHOUT_TIME_ZONE, TIMESTAMP_WITH_LOCAL_TIME_ZONE, and ARRAY"));
            throw new UnsupportedOperationException(notSupportedError);
        }
        catch (ClassCastException | IllegalArgumentException | IllegalStateException | IndexOutOfBoundsException | NullPointerException | UnsupportedOperationException | DateTimeException e) {
            String invalidError = String.format("Error while converting RowData value '%s' to BigQuery Proto Rows.%nError: %s", element, e);
            LOG.error(String.format("%s%nExpected Type: '%s' at Field Number '%d' for Logical Type: '%s'.%nError: %s", invalidError, fieldDescriptor.getType().name(), fieldNumber, fieldType.getTypeRoot().name(), e));
            throw new IllegalArgumentException(invalidError);
        }
    }

    private static LogicalType getArrayElementType(LogicalType fieldType) throws UnsupportedOperationException {
        List arrayElementTypes = fieldType.getChildren();
        if (fieldType.isNullable()) {
            throw new UnsupportedOperationException("NULLABLE ARRAY is not supported.");
        }
        if (arrayElementTypes.size() > 1) {
            throw new UnsupportedOperationException("Multiple Datatypes not supported in ARRAY type");
        }
        LogicalType arrayElementType = (LogicalType)arrayElementTypes.get(0);
        if (arrayElementType.getTypeRoot() == LogicalTypeRoot.NULL) {
            throw new UnsupportedOperationException("ARRAY of type NULL is not supported.");
        }
        return arrayElementType;
    }

    private long getMicrosFromTsData(TimestampData timestampData) {
        long millis = timestampData.getMillisecond();
        long nanos = timestampData.getNanoOfMillisecond();
        return TimeUnit.MILLISECONDS.toMicros(millis) + TimeUnit.NANOSECONDS.toMicros(nanos);
    }

    private Object convertArrayElement(ArrayData.ElementGetter elementGetter, RowData element, int fieldNumber, int pos, LogicalType arrayElementType, Descriptors.FieldDescriptor fieldDescriptor) {
        Object ele = elementGetter.getElementOrNull(element.getArray(fieldNumber), pos);
        return this.toProtoValue(arrayElementType, 0, (RowData)GenericRowData.of((Object[])new Object[]{ele}), fieldDescriptor);
    }

    public DynamicMessage getDynamicMessageFromRowData(RowData element, Descriptors.Descriptor descriptor, LogicalType type) {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        int fieldNumber = 0;
        for (LogicalType fieldType : type.getChildren()) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)Preconditions.checkNotNull((Object)descriptor.findFieldByNumber(fieldNumber + 1));
            if (element.isNullAt(fieldNumber)) {
                if (fieldDescriptor.isRequired()) {
                    throw new IllegalArgumentException("Received null value for non-nullable field " + fieldDescriptor.getName());
                }
            } else {
                Object value = this.toProtoValue(fieldType, fieldNumber, element, fieldDescriptor);
                builder.setField(fieldDescriptor, value);
            }
            ++fieldNumber;
        }
        return builder.build();
    }
}

