/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.sink.throttle;

import com.google.cloud.flink.bigquery.sink.throttle.Throttler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteStreamCreationThrottler
implements Throttler {
    public static final int MAX_BUCKETS = 42;
    private static final Logger LOG = LoggerFactory.getLogger(WriteStreamCreationThrottler.class);
    private final int writerId;

    public WriteStreamCreationThrottler(int writerId) {
        this.writerId = writerId;
    }

    @Override
    public void throttle() {
        int waitSeconds = this.writerId % 42;
        LOG.debug("Throttling writer {} for {} second", (Object)this.writerId, (Object)waitSeconds);
        try {
            TimeUnit.SECONDS.sleep(waitSeconds);
        }
        catch (InterruptedException e) {
            LOG.warn("Throttle attempt interrupted in subtask {}", (Object)this.writerId);
            Thread.currentThread().interrupt();
        }
    }
}

