/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source;

import com.google.cloud.flink.bigquery.source.BigQuerySource;
import com.google.cloud.flink.bigquery.source.config.BigQueryReadOptions;
import com.google.cloud.flink.bigquery.source.reader.deserializer.BigQueryDeserializationSchema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.connector.source.Boundedness;

final class AutoValue_BigQuerySource<OUT>
extends BigQuerySource<OUT> {
    private final BigQueryDeserializationSchema<GenericRecord, OUT> deserializationSchema;
    private final BigQueryReadOptions readOptions;
    private final Boundedness sourceBoundedness;

    private AutoValue_BigQuerySource(BigQueryDeserializationSchema<GenericRecord, OUT> deserializationSchema, BigQueryReadOptions readOptions, Boundedness sourceBoundedness) {
        this.deserializationSchema = deserializationSchema;
        this.readOptions = readOptions;
        this.sourceBoundedness = sourceBoundedness;
    }

    @Override
    public BigQueryDeserializationSchema<GenericRecord, OUT> getDeserializationSchema() {
        return this.deserializationSchema;
    }

    @Override
    public BigQueryReadOptions getReadOptions() {
        return this.readOptions;
    }

    @Override
    public Boundedness getSourceBoundedness() {
        return this.sourceBoundedness;
    }

    public String toString() {
        return "BigQuerySource{deserializationSchema=" + this.deserializationSchema + ", readOptions=" + this.readOptions + ", sourceBoundedness=" + this.sourceBoundedness + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigQuerySource) {
            BigQuerySource that = (BigQuerySource)o;
            return this.deserializationSchema.equals(that.getDeserializationSchema()) && this.readOptions.equals((Object)that.getReadOptions()) && this.sourceBoundedness.equals((Object)that.getSourceBoundedness());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.deserializationSchema.hashCode();
        h$ *= 1000003;
        h$ ^= this.readOptions.hashCode();
        h$ *= 1000003;
        return h$ ^= this.sourceBoundedness.hashCode();
    }

    @Override
    public BigQuerySource.Builder<OUT> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<OUT>
    extends BigQuerySource.Builder<OUT> {
        private BigQueryDeserializationSchema<GenericRecord, OUT> deserializationSchema;
        private BigQueryReadOptions readOptions;
        private Boundedness sourceBoundedness;

        Builder() {
        }

        private Builder(BigQuerySource<OUT> source) {
            this.deserializationSchema = source.getDeserializationSchema();
            this.readOptions = source.getReadOptions();
            this.sourceBoundedness = source.getSourceBoundedness();
        }

        @Override
        public BigQuerySource.Builder<OUT> setDeserializationSchema(BigQueryDeserializationSchema<GenericRecord, OUT> deserializationSchema) {
            if (deserializationSchema == null) {
                throw new NullPointerException("Null deserializationSchema");
            }
            this.deserializationSchema = deserializationSchema;
            return this;
        }

        @Override
        public BigQuerySource.Builder<OUT> setReadOptions(BigQueryReadOptions readOptions) {
            if (readOptions == null) {
                throw new NullPointerException("Null readOptions");
            }
            this.readOptions = readOptions;
            return this;
        }

        @Override
        public BigQuerySource.Builder<OUT> setSourceBoundedness(Boundedness sourceBoundedness) {
            if (sourceBoundedness == null) {
                throw new NullPointerException("Null sourceBoundedness");
            }
            this.sourceBoundedness = sourceBoundedness;
            return this;
        }

        @Override
        public BigQuerySource<OUT> build() {
            if (this.deserializationSchema == null || this.readOptions == null || this.sourceBoundedness == null) {
                StringBuilder missing = new StringBuilder();
                if (this.deserializationSchema == null) {
                    missing.append(" deserializationSchema");
                }
                if (this.readOptions == null) {
                    missing.append(" readOptions");
                }
                if (this.sourceBoundedness == null) {
                    missing.append(" sourceBoundedness");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigQuerySource(this.deserializationSchema, this.readOptions, this.sourceBoundedness);
        }
    }
}

