/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.auto.value.AutoValue;
import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.common.exceptions.BigQueryConnectorException;
import com.google.cloud.flink.bigquery.common.utils.SchemaTransform;
import com.google.cloud.flink.bigquery.services.BigQueryServicesFactory;
import com.google.cloud.flink.bigquery.source.AutoValue_BigQuerySource;
import com.google.cloud.flink.bigquery.source.config.BigQueryReadOptions;
import com.google.cloud.flink.bigquery.source.emitter.BigQueryRecordEmitter;
import com.google.cloud.flink.bigquery.source.enumerator.BigQuerySourceEnumState;
import com.google.cloud.flink.bigquery.source.enumerator.BigQuerySourceEnumStateSerializer;
import com.google.cloud.flink.bigquery.source.enumerator.BigQuerySourceEnumerator;
import com.google.cloud.flink.bigquery.source.reader.BigQuerySourceReader;
import com.google.cloud.flink.bigquery.source.reader.BigQuerySourceReaderContext;
import com.google.cloud.flink.bigquery.source.reader.deserializer.AvroDeserializationSchema;
import com.google.cloud.flink.bigquery.source.reader.deserializer.BigQueryDeserializationSchema;
import com.google.cloud.flink.bigquery.source.split.BigQuerySourceSplit;
import com.google.cloud.flink.bigquery.source.split.BigQuerySourceSplitSerializer;
import com.google.cloud.flink.bigquery.source.split.reader.BigQuerySourceSplitReader;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
@PublicEvolving
public abstract class BigQuerySource<OUT>
implements Source<OUT, BigQuerySourceSplit, BigQuerySourceEnumState>,
ResultTypeQueryable<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySource.class);

    public abstract BigQueryDeserializationSchema<GenericRecord, OUT> getDeserializationSchema();

    public abstract BigQueryReadOptions getReadOptions();

    public abstract Boundedness getSourceBoundedness();

    public Boundedness getBoundedness() {
        return this.getSourceBoundedness();
    }

    public SimpleVersionedSerializer<BigQuerySourceSplit> getSplitSerializer() {
        return BigQuerySourceSplitSerializer.INSTANCE;
    }

    public SimpleVersionedSerializer<BigQuerySourceEnumState> getEnumeratorCheckpointSerializer() {
        return BigQuerySourceEnumStateSerializer.INSTANCE;
    }

    public TypeInformation<OUT> getProducedType() {
        return this.getDeserializationSchema().getProducedType();
    }

    public SourceReader<OUT, BigQuerySourceSplit> createReader(SourceReaderContext readerContext) throws Exception {
        FutureCompletingBlockingQueue elementsQueue = new FutureCompletingBlockingQueue();
        BigQuerySourceReaderContext bqReaderContext = new BigQuerySourceReaderContext(readerContext, this.getReadOptions().getLimit().orElse(-1));
        Supplier<SplitReader<GenericRecord, BigQuerySourceSplit>> splitReaderSupplier = () -> new BigQuerySourceSplitReader(this.getReadOptions(), bqReaderContext);
        return new BigQuerySourceReader((FutureCompletingBlockingQueue<RecordsWithSplitIds<GenericRecord>>)elementsQueue, splitReaderSupplier, new BigQueryRecordEmitter<OUT>(this.getDeserializationSchema()), bqReaderContext);
    }

    public SplitEnumerator<BigQuerySourceSplit, BigQuerySourceEnumState> createEnumerator(SplitEnumeratorContext<BigQuerySourceSplit> enumContext) throws Exception {
        return new BigQuerySourceEnumerator(this.getBoundedness(), enumContext, this.getReadOptions(), BigQuerySourceEnumState.initialState());
    }

    public SplitEnumerator<BigQuerySourceSplit, BigQuerySourceEnumState> restoreEnumerator(SplitEnumeratorContext<BigQuerySourceSplit> enumContext, BigQuerySourceEnumState checkpoint) throws Exception {
        LOG.debug("Restoring enumerator with state {}", (Object)checkpoint);
        return new BigQuerySourceEnumerator(this.getBoundedness(), enumContext, this.getReadOptions(), checkpoint);
    }

    public abstract Builder<OUT> toBuilder();

    public static <OUT> Builder<OUT> builder() {
        return new AutoValue_BigQuerySource.Builder().setSourceBoundedness(Boundedness.BOUNDED);
    }

    public static BigQuerySource<GenericRecord> readAvrosFromQuery(String query, String gcpProject, Integer limit) throws IOException {
        BigQueryReadOptions readOptions = BigQueryReadOptions.builder().setQueryAndExecutionProject(query, gcpProject).setLimit(limit).build();
        return BigQuerySource.readAvrosFromQuery(readOptions);
    }

    @VisibleForTesting
    static BigQuerySource<GenericRecord> readAvrosFromQuery(BigQueryReadOptions readOptions) throws IOException {
        BigQueryConnectOptions connectOptions = readOptions.getBigQueryConnectOptions();
        TableSchema tableSchema = readOptions.getQueryExecutionProject().map(gcpProject -> readOptions.getQuery().map(query -> BigQueryServicesFactory.instance((BigQueryConnectOptions)connectOptions).queryClient().dryRunQuery(gcpProject, query).getStatistics().getQuery().getSchema()).orElseThrow(() -> new BigQueryConnectorException("Can't read query results without setting a SQL query."))).orElseThrow(() -> new BigQueryConnectorException("Can't read query results without setting a GCP project."));
        return BigQuerySource.builder().setDeserializationSchema(new AvroDeserializationSchema(SchemaTransform.toGenericAvroSchema((String)"queryresultschema", (List)tableSchema.getFields()).toString())).setReadOptions(readOptions).build();
    }

    public static BigQuerySource<GenericRecord> readAvrosFromQuery(String query, String gcpProject) throws IOException {
        return BigQuerySource.readAvrosFromQuery(query, gcpProject, -1);
    }

    public static BigQuerySource<GenericRecord> readAvros(BigQueryReadOptions readOptions) {
        BigQueryConnectOptions connectOptions = readOptions.getBigQueryConnectOptions();
        TableSchema tableSchema = BigQueryServicesFactory.instance((BigQueryConnectOptions)connectOptions).queryClient().getTableSchema(connectOptions.getProjectId(), connectOptions.getDataset(), connectOptions.getTable());
        return BigQuerySource.builder().setDeserializationSchema(new AvroDeserializationSchema(SchemaTransform.toGenericAvroSchema((String)String.format("%s.%s.%s", connectOptions.getProjectId(), connectOptions.getDataset(), BigQuerySource.sanitizeAvroSchemaName(connectOptions.getTable())), (List)tableSchema.getFields()).toString())).setReadOptions(readOptions).build();
    }

    public static BigQuerySource<GenericRecord> streamAvros(BigQueryReadOptions readOptions) {
        BigQueryConnectOptions connectOptions = readOptions.getBigQueryConnectOptions();
        TableSchema tableSchema = BigQueryServicesFactory.instance((BigQueryConnectOptions)connectOptions).queryClient().getTableSchema(connectOptions.getProjectId(), connectOptions.getDataset(), connectOptions.getTable());
        return BigQuerySource.builder().setDeserializationSchema(new AvroDeserializationSchema(SchemaTransform.toGenericAvroSchema((String)String.format("%s.%s.%s", connectOptions.getProjectId(), connectOptions.getDataset(), BigQuerySource.sanitizeAvroSchemaName(connectOptions.getTable())), (List)tableSchema.getFields()).toString())).setReadOptions(readOptions).setSourceBoundedness(Boundedness.CONTINUOUS_UNBOUNDED).build();
    }

    private static String sanitizeAvroSchemaName(String name) {
        if (name == null) {
            return name;
        }
        int length = name.length();
        if (length == 0) {
            return name;
        }
        String newName = "";
        char first = name.charAt(0);
        newName = Character.isLetter(first) || first == '_' ? newName + first : newName + '_';
        for (int i = 1; i < length; ++i) {
            char c = name.charAt(i);
            newName = Character.isLetterOrDigit(c) || c == '_' ? newName + c : newName + '_';
        }
        return newName;
    }

    @AutoValue.Builder
    public static abstract class Builder<OUT> {
        public abstract Builder<OUT> setDeserializationSchema(BigQueryDeserializationSchema<GenericRecord, OUT> var1);

        public abstract Builder<OUT> setReadOptions(BigQueryReadOptions var1);

        public abstract Builder<OUT> setSourceBoundedness(Boundedness var1);

        public abstract BigQuerySource<OUT> build();
    }
}

