/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source.emitter;

import com.google.cloud.flink.bigquery.source.reader.deserializer.BigQueryDeserializationSchema;
import com.google.cloud.flink.bigquery.source.split.BigQuerySourceSplitState;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.util.Collector;

@Internal
public class BigQueryRecordEmitter<T>
implements RecordEmitter<GenericRecord, T, BigQuerySourceSplitState> {
    private final BigQueryDeserializationSchema<GenericRecord, T> deserializationSchema;
    private final SourceOutputWrapper<T> sourceOutputWrapper;

    public BigQueryRecordEmitter(BigQueryDeserializationSchema<GenericRecord, T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
        this.sourceOutputWrapper = new SourceOutputWrapper();
    }

    public void emitRecord(GenericRecord record, SourceOutput<T> output, BigQuerySourceSplitState splitState) throws Exception {
        splitState.updateOffset();
        ((SourceOutputWrapper)this.sourceOutputWrapper).setSourceOutput(output);
        this.deserializationSchema.deserialize(record, this.sourceOutputWrapper);
    }

    private static class SourceOutputWrapper<T>
    implements Collector<T> {
        private SourceOutput<T> sourceOutput;

        private SourceOutputWrapper() {
        }

        public void collect(T record) {
            this.sourceOutput.collect(record);
        }

        public void close() {
        }

        private void setSourceOutput(SourceOutput<T> sourceOutput) {
            this.sourceOutput = sourceOutput;
        }
    }
}

