/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source.enumerator;

import com.google.cloud.flink.bigquery.source.split.BigQuerySourceSplit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public class BigQuerySourceEnumState {
    private final List<String> lastSeenPartitions;
    private final List<String> remaniningTableStreams;
    private final List<String> completedTableStreams;
    private final List<BigQuerySourceSplit> remainingSourceSplits;
    private final Map<String, BigQuerySourceSplit> assignedSourceSplits;
    private final Boolean initialized;

    public BigQuerySourceEnumState(List<String> lastSeenPartitions, List<String> remaniningTableStreams, List<String> completedTableStreams, List<BigQuerySourceSplit> remainingSourceSplits, Map<String, BigQuerySourceSplit> assignedSourceSplits, Boolean initialized) {
        this.lastSeenPartitions = new ArrayList<String>(lastSeenPartitions);
        this.remaniningTableStreams = new ArrayList<String>(remaniningTableStreams);
        this.completedTableStreams = new ArrayList<String>(completedTableStreams);
        this.remainingSourceSplits = new ArrayList<BigQuerySourceSplit>(remainingSourceSplits);
        this.assignedSourceSplits = new HashMap<String, BigQuerySourceSplit>(assignedSourceSplits);
        this.initialized = initialized;
    }

    public List<String> getLastSeenPartitions() {
        return this.lastSeenPartitions;
    }

    public List<String> getRemaniningTableStreams() {
        return this.remaniningTableStreams;
    }

    public List<String> getCompletedTableStreams() {
        return this.completedTableStreams;
    }

    public List<BigQuerySourceSplit> getRemainingSourceSplits() {
        return this.remainingSourceSplits;
    }

    public Map<String, BigQuerySourceSplit> getAssignedSourceSplits() {
        return this.assignedSourceSplits;
    }

    public Boolean isInitialized() {
        return this.initialized;
    }

    public static BigQuerySourceEnumState initialState() {
        return new BigQuerySourceEnumState(new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<BigQuerySourceSplit>(), new HashMap<String, BigQuerySourceSplit>(), false);
    }

    public int hashCode() {
        return Objects.hash(this.lastSeenPartitions, this.remaniningTableStreams, this.completedTableStreams, this.remainingSourceSplits, this.assignedSourceSplits, this.initialized);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigQuerySourceEnumState other = (BigQuerySourceEnumState)obj;
        return Objects.equals(this.lastSeenPartitions, other.lastSeenPartitions) && Objects.equals(this.remaniningTableStreams, other.remaniningTableStreams) && Objects.equals(this.completedTableStreams, other.completedTableStreams) && Objects.equals(this.remainingSourceSplits, other.remainingSourceSplits) && Objects.equals(this.assignedSourceSplits, other.assignedSourceSplits) && Objects.equals(this.initialized, other.initialized);
    }

    public String toString() {
        return String.format("BigQuerySourceEnumState{lastSeenPartitions=%s, remaniningTableStreams=%s, completedTableStreams=%s, remainingSourceSplits=%s, assignedSourceSplits=%s, initialized=%s}", this.lastSeenPartitions, this.remaniningTableStreams, this.completedTableStreams, this.remainingSourceSplits, this.assignedSourceSplits, this.initialized);
    }
}

