/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source.reader;

import com.google.cloud.flink.bigquery.source.split.BigQuerySourceSplit;
import com.google.cloud.flink.bigquery.source.split.BigQuerySourceSplitState;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.SingleThreadMultiplexSourceReaderBase;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BigQuerySourceReader<OUT>
extends SingleThreadMultiplexSourceReaderBase<GenericRecord, OUT, BigQuerySourceSplit, BigQuerySourceSplitState> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySourceReader.class);

    public BigQuerySourceReader(FutureCompletingBlockingQueue<RecordsWithSplitIds<GenericRecord>> elementsQueue, Supplier<SplitReader<GenericRecord, BigQuerySourceSplit>> splitReaderSupplier, RecordEmitter<GenericRecord, OUT, BigQuerySourceSplitState> recordEmitter, Configuration config, SourceReaderContext context) {
        super(elementsQueue, splitReaderSupplier, recordEmitter, config, context);
    }

    public BigQuerySourceReader(FutureCompletingBlockingQueue<RecordsWithSplitIds<GenericRecord>> elementsQueue, Supplier<SplitReader<GenericRecord, BigQuerySourceSplit>> splitReaderSupplier, RecordEmitter<GenericRecord, OUT, BigQuerySourceSplitState> recordEmitter, SourceReaderContext context) {
        super(elementsQueue, splitReaderSupplier, recordEmitter, new Configuration(), context);
    }

    public void start() {
        if (this.getNumberOfCurrentlyAssignedSplits() == 0) {
            this.context.sendSplitRequest();
        }
    }

    protected void onSplitFinished(Map<String, BigQuerySourceSplitState> finishedSplitIds) {
        for (BigQuerySourceSplitState splitState : finishedSplitIds.values()) {
            BigQuerySourceSplit sourceSplit = splitState.toBigQuerySourceSplit();
            LOG.info("Read for split {} is completed.", (Object)sourceSplit.splitId());
        }
        this.context.sendSplitRequest();
    }

    protected BigQuerySourceSplitState initializedState(BigQuerySourceSplit split) {
        return new BigQuerySourceSplitState(split);
    }

    protected BigQuerySourceSplit toSplitType(String string, BigQuerySourceSplitState sst) {
        return sst.toBigQuerySourceSplit();
    }
}

