/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source.reader;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.groups.SourceReaderMetricGroup;
import org.apache.flink.util.UserCodeClassLoader;

@Internal
public class BigQuerySourceReaderContext
implements SourceReaderContext {
    private final SourceReaderContext readerContext;
    private final AtomicLong readCount = new AtomicLong(0L);
    private final int limit;

    public BigQuerySourceReaderContext(SourceReaderContext readerContext, int limit) {
        this.readerContext = readerContext;
        this.limit = limit;
    }

    public SourceReaderMetricGroup metricGroup() {
        return this.readerContext.metricGroup();
    }

    public Configuration getConfiguration() {
        return this.readerContext.getConfiguration();
    }

    public String getLocalHostName() {
        return this.readerContext.getLocalHostName();
    }

    public int getIndexOfSubtask() {
        return this.readerContext.getIndexOfSubtask();
    }

    public void sendSplitRequest() {
        this.readerContext.sendSplitRequest();
    }

    public void sendSourceEventToCoordinator(SourceEvent sourceEvent) {
        this.readerContext.sendSourceEventToCoordinator(sourceEvent);
    }

    public UserCodeClassLoader getUserCodeClassLoader() {
        return this.readerContext.getUserCodeClassLoader();
    }

    public Long updateReadCount(Long newReads) {
        return this.readCount.addAndGet(newReads);
    }

    public Long currentReadCount() {
        return this.readCount.get();
    }

    public boolean isLimitPushedDown() {
        return this.limit > 0;
    }

    public boolean willExceedLimit(int newReads) {
        return this.limit > 0 && this.readCount.get() + (long)newReads >= (long)this.limit;
    }
}

