/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source.reader.deserializer;

import com.google.cloud.flink.bigquery.source.reader.deserializer.AvroToRowDataConverters;
import com.google.cloud.flink.bigquery.source.reader.deserializer.BigQueryDeserializationSchema;
import java.io.IOException;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class AvroToRowDataDeserializationSchema
implements BigQueryDeserializationSchema<GenericRecord, RowData> {
    private final AvroToRowDataConverters.AvroToRowDataConverter converter;
    private final TypeInformation<RowData> typeInfo;

    public AvroToRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> typeInfo) {
        this.converter = AvroToRowDataConverters.createRowConverter(rowType);
        this.typeInfo = typeInfo;
    }

    @Override
    public RowData deserialize(GenericRecord record) throws IOException {
        return (GenericRowData)this.converter.convert(record);
    }

    public TypeInformation<RowData> getProducedType() {
        return this.typeInfo;
    }
}

