/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source.split;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.source.SourceSplit;

@PublicEvolving
public class BigQuerySourceSplit
implements SourceSplit,
Serializable {
    private final String streamName;
    private final Long offset;

    public BigQuerySourceSplit(String streamName) {
        this.streamName = streamName;
        this.offset = 0L;
    }

    public BigQuerySourceSplit(String streamName, Long offset) {
        this.streamName = streamName;
        this.offset = offset;
    }

    public String splitId() {
        return this.streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Long getOffset() {
        return this.offset;
    }

    public int hashCode() {
        return Objects.hash(this.streamName, this.offset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigQuerySourceSplit other = (BigQuerySourceSplit)obj;
        if (!Objects.equals(this.streamName, other.streamName)) {
            return false;
        }
        return Objects.equals(this.offset, other.offset);
    }

    public String toString() {
        return "BigQuerySourceSplit{streamName=" + this.streamName + ", offset=" + this.offset + '}';
    }
}

