/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.source.split.assigner;

import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.services.BigQueryServicesFactory;
import com.google.cloud.flink.bigquery.services.QueryResultInfo;
import com.google.cloud.flink.bigquery.source.config.BigQueryReadOptions;
import com.google.cloud.flink.bigquery.source.enumerator.BigQuerySourceEnumState;
import com.google.cloud.flink.bigquery.source.split.SplitDiscoverer;
import com.google.cloud.flink.bigquery.source.split.assigner.BigQuerySourceSplitAssigner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BoundedSplitAssigner
extends BigQuerySourceSplitAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(BoundedSplitAssigner.class);

    BoundedSplitAssigner(BigQueryReadOptions readOptions, BigQuerySourceEnumState sourceEnumState) {
        super(readOptions, sourceEnumState);
    }

    @Override
    public void discoverSplits() {
        BigQueryConnectOptions connectionOptions = this.fetchOptionsFromQueryRun().orElse(this.readOptions.getBigQueryConnectOptions());
        this.remainingTableStreams.addAll(SplitDiscoverer.discoverSplits((BigQueryConnectOptions)connectionOptions, (DataFormat)DataFormat.AVRO, (List)this.readOptions.getColumnNames(), (String)this.readOptions.getRowRestriction(), (Optional)this.readOptions.getSnapshotTimestampInMillis(), (Integer)this.readOptions.getMaxStreamCount()));
    }

    Optional<BigQueryConnectOptions> fetchOptionsFromQueryRun() {
        return this.readOptions.getQuery().flatMap(query -> this.runQuery((String)query)).map(result -> {
            if (result.getStatus().equals((Object)QueryResultInfo.Status.FAILED)) {
                throw new IllegalStateException("The BigQuery query execution failed with errors: " + result.getErrorMessages().orElse(new ArrayList()));
            }
            String projectId = (String)result.getDestinationProject().get();
            String dataset = (String)result.getDestinationDataset().get();
            String table = (String)result.getDestinationTable().get();
            LOG.info("After BigQuery query execution, switching connect options to read from table {}.{}.{}", new Object[]{projectId, dataset, table});
            return this.readOptions.getBigQueryConnectOptions().toBuilder().setProjectId(projectId).setDataset(dataset).setTable(table).build();
        });
    }

    private Optional<QueryResultInfo> runQuery(String query) {
        return this.readOptions.getQueryExecutionProject().flatMap(gcpProject -> BigQueryServicesFactory.instance((BigQueryConnectOptions)this.readOptions.getBigQueryConnectOptions()).queryClient().runQuery(gcpProject, query));
    }

    @Override
    public boolean noMoreSplits() {
        Preconditions.checkState((boolean)this.initialized, (Object)"The noMoreSplits method was called but not initialized.");
        return this.remainingTableStreams.isEmpty() && this.remainingSourceSplits.isEmpty();
    }
}

