/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.table;

import com.google.cloud.flink.bigquery.services.BigQueryServices;
import com.google.cloud.flink.bigquery.table.BigQueryDynamicTableSink;
import com.google.cloud.flink.bigquery.table.BigQueryDynamicTableSource;
import com.google.cloud.flink.bigquery.table.config.BigQueryConnectorOptions;
import com.google.cloud.flink.bigquery.table.config.BigQueryTableConfigurationProvider;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.function.SerializableSupplier;

@Internal
public class BigQueryDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "bigquery";
    private static SerializableSupplier<BigQueryServices> testingServices = null;

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet requiredOptions = new HashSet();
        requiredOptions.add(BigQueryConnectorOptions.PROJECT);
        requiredOptions.add(BigQueryConnectorOptions.DATASET);
        requiredOptions.add(BigQueryConnectorOptions.TABLE);
        return requiredOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet additionalOptions = new HashSet();
        additionalOptions.add(BigQueryConnectorOptions.LIMIT);
        additionalOptions.add(BigQueryConnectorOptions.ROW_RESTRICTION);
        additionalOptions.add(BigQueryConnectorOptions.COLUMNS_PROJECTION);
        additionalOptions.add(BigQueryConnectorOptions.MAX_STREAM_COUNT);
        additionalOptions.add(BigQueryConnectorOptions.SNAPSHOT_TIMESTAMP);
        additionalOptions.add(BigQueryConnectorOptions.CREDENTIALS_ACCESS_TOKEN);
        additionalOptions.add(BigQueryConnectorOptions.CREDENTIALS_FILE);
        additionalOptions.add(BigQueryConnectorOptions.CREDENTIALS_KEY);
        additionalOptions.add(BigQueryConnectorOptions.TEST_MODE);
        additionalOptions.add(BigQueryConnectorOptions.MODE);
        additionalOptions.add(BigQueryConnectorOptions.DELIVERY_GUARANTEE);
        additionalOptions.add(BigQueryConnectorOptions.PARTITION_DISCOVERY_INTERVAL);
        additionalOptions.add(BigQueryConnectorOptions.SINK_PARALLELISM);
        return additionalOptions;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        HashSet forwardOptions = new HashSet();
        forwardOptions.add(BigQueryConnectorOptions.PROJECT);
        forwardOptions.add(BigQueryConnectorOptions.DATASET);
        forwardOptions.add(BigQueryConnectorOptions.TABLE);
        forwardOptions.add(BigQueryConnectorOptions.LIMIT);
        forwardOptions.add(BigQueryConnectorOptions.MODE);
        forwardOptions.add(BigQueryConnectorOptions.ROW_RESTRICTION);
        forwardOptions.add(BigQueryConnectorOptions.COLUMNS_PROJECTION);
        forwardOptions.add(BigQueryConnectorOptions.MAX_STREAM_COUNT);
        forwardOptions.add(BigQueryConnectorOptions.SNAPSHOT_TIMESTAMP);
        forwardOptions.add(BigQueryConnectorOptions.CREDENTIALS_ACCESS_TOKEN);
        forwardOptions.add(BigQueryConnectorOptions.CREDENTIALS_FILE);
        forwardOptions.add(BigQueryConnectorOptions.CREDENTIALS_KEY);
        forwardOptions.add(BigQueryConnectorOptions.DELIVERY_GUARANTEE);
        forwardOptions.add(BigQueryConnectorOptions.PARTITION_DISCOVERY_INTERVAL);
        forwardOptions.add(BigQueryConnectorOptions.SINK_PARALLELISM);
        return forwardOptions;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        BigQueryTableConfigurationProvider configProvider = new BigQueryTableConfigurationProvider(helper.getOptions());
        helper.validate();
        if (configProvider.isTestModeEnabled()) {
            configProvider = configProvider.withTestingServices(testingServices);
        }
        return new BigQueryDynamicTableSource(configProvider.toBigQueryReadOptions(), context.getPhysicalRowDataType(), configProvider.isUnboundedEnabled() ? Boundedness.CONTINUOUS_UNBOUNDED : Boundedness.BOUNDED);
    }

    static void setTestingServices(SerializableSupplier<BigQueryServices> testingServices) {
        BigQueryDynamicTableFactory.testingServices = testingServices;
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        BigQueryTableConfigurationProvider configProvider = new BigQueryTableConfigurationProvider(helper.getOptions());
        helper.validate();
        if (configProvider.isTestModeEnabled()) {
            configProvider = configProvider.withTestingServices(testingServices);
        }
        return new BigQueryDynamicTableSink(configProvider.translateBigQueryConnectOptions(), configProvider.translateDeliveryGuarantee(), context.getPhysicalRowDataType().getLogicalType(), configProvider.getParallelism().orElse(null));
    }
}

