/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.table;

import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.sink.BigQuerySink;
import com.google.cloud.flink.bigquery.sink.BigQuerySinkConfig;
import com.google.cloud.flink.bigquery.sink.serializer.RowDataToProtoSerializer;
import java.util.Objects;
import java.util.ResourceBundle;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class BigQueryDynamicTableSink
implements DynamicTableSink {
    private final BigQuerySinkConfig sinkConfig;
    private final LogicalType logicalType;
    private final Integer parallelism;

    public BigQueryDynamicTableSink(BigQueryConnectOptions connectOptions, DeliveryGuarantee deliveryGuarantee, LogicalType logicalType) {
        this(connectOptions, deliveryGuarantee, logicalType, null);
    }

    public BigQueryDynamicTableSink(BigQueryConnectOptions connectOptions, DeliveryGuarantee deliveryGuarantee, LogicalType logicalType, Integer parallelism) {
        this.logicalType = logicalType;
        this.sinkConfig = BigQuerySinkConfig.forTable(connectOptions, deliveryGuarantee, logicalType);
        this.parallelism = parallelism;
    }

    public int hashCode() {
        return Objects.hash(this.sinkConfig, this.logicalType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigQueryDynamicTableSink object = (BigQueryDynamicTableSink)obj;
        return this.logicalType == object.logicalType && this.sinkConfig.equals(object.sinkConfig);
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return ChangelogMode.insertOnly();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        ((RowDataToProtoSerializer)this.sinkConfig.getSerializer()).setLogicalType(this.logicalType);
        if (this.parallelism == null) {
            return SinkV2Provider.of((Sink)BigQuerySink.get(this.sinkConfig));
        }
        return SinkV2Provider.of((Sink)BigQuerySink.get(this.sinkConfig), (Integer)this.parallelism);
    }

    public DynamicTableSink copy() {
        if (this.parallelism == null) {
            return new BigQueryDynamicTableSink(this.sinkConfig.getConnectOptions(), this.sinkConfig.getDeliveryGuarantee(), this.logicalType);
        }
        return new BigQueryDynamicTableSink(this.sinkConfig.getConnectOptions(), this.sinkConfig.getDeliveryGuarantee(), this.logicalType, this.parallelism);
    }

    public String asSummaryString() {
        ResourceBundle connectorResources = ResourceBundle.getBundle("connector");
        return connectorResources.getString("connector");
    }

    @VisibleForTesting
    LogicalType getLogicalType() {
        return this.logicalType;
    }

    @VisibleForTesting
    BigQuerySinkConfig getSinkConfig() {
        return this.sinkConfig;
    }

    @VisibleForTesting
    Integer getSinkParallelism() {
        return this.parallelism;
    }
}

