/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.table;

import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.common.utils.BigQueryPartitionUtils;
import com.google.cloud.flink.bigquery.services.BigQueryServices;
import com.google.cloud.flink.bigquery.services.BigQueryServicesFactory;
import com.google.cloud.flink.bigquery.services.TablePartitionInfo;
import com.google.cloud.flink.bigquery.source.BigQuerySource;
import com.google.cloud.flink.bigquery.source.config.BigQueryReadOptions;
import com.google.cloud.flink.bigquery.source.reader.deserializer.AvroToRowDataDeserializationSchema;
import com.google.cloud.flink.bigquery.table.restrictions.BigQueryRestriction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsPartitionPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BigQueryDynamicTableSource
implements ScanTableSource,
SupportsProjectionPushDown,
SupportsLimitPushDown,
SupportsFilterPushDown,
SupportsPartitionPushDown {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryDynamicTableSource.class);
    private BigQueryReadOptions readOptions;
    private DataType producedDataType;
    private final Boundedness boundedness;

    public BigQueryDynamicTableSource(BigQueryReadOptions readOptions, DataType producedDataType) {
        this(readOptions, producedDataType, Boundedness.BOUNDED);
    }

    public BigQueryDynamicTableSource(BigQueryReadOptions readOptions, DataType producedDataType, Boundedness boundedness) {
        this.readOptions = readOptions;
        this.producedDataType = producedDataType;
        this.boundedness = boundedness;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        RowType rowType = (RowType)this.producedDataType.getLogicalType();
        TypeInformation typeInfo = runtimeProviderContext.createTypeInformation(this.producedDataType);
        BigQuerySource<RowData> bqSource = BigQuerySource.builder().setReadOptions(this.readOptions).setSourceBoundedness(this.boundedness).setDeserializationSchema(new AvroToRowDataDeserializationSchema(rowType, (TypeInformation<RowData>)typeInfo)).build();
        return SourceProvider.of(bqSource);
    }

    public DynamicTableSource copy() {
        return new BigQueryDynamicTableSource(this.readOptions, this.producedDataType, this.boundedness);
    }

    public String asSummaryString() {
        ResourceBundle connectorResources = ResourceBundle.getBundle("connector");
        return connectorResources.getString("connector");
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public void applyProjection(int[][] projectedFields, DataType producedDataType) {
        this.producedDataType = producedDataType;
        this.readOptions = this.readOptions.toBuilder().setColumnNames(DataType.getFieldNames((DataType)producedDataType)).build();
    }

    public void applyLimit(long limit) {
        this.readOptions.toBuilder().setLimit(Integer.valueOf((int)limit)).build();
    }

    public SupportsFilterPushDown.Result applyFilters(List<ResolvedExpression> filters) {
        Map<Boolean, List<Tuple3>> translatedFilters = filters.stream().map(expression -> Tuple2.of((Object)expression, BigQueryRestriction.convert((Expression)expression))).map(transExp -> Tuple3.of((Object)((Optional)transExp.f1).isPresent(), (Object)((Optional)transExp.f1).orElse(""), (Object)transExp.f0)).collect(Collectors.groupingBy(t -> (Boolean)t.f0));
        String rowRestrictionByFilters = ((List)translatedFilters.getOrDefault(true, new ArrayList())).stream().map(t -> (String)t.f1).collect(Collectors.joining(" AND "));
        String newRowRestriction = this.readOptions.getRowRestriction();
        if (!rowRestrictionByFilters.isEmpty()) {
            newRowRestriction = newRowRestriction.isEmpty() ? rowRestrictionByFilters : newRowRestriction + " AND " + rowRestrictionByFilters;
        }
        this.readOptions = this.readOptions.toBuilder().setRowRestriction(newRowRestriction).build();
        return SupportsFilterPushDown.Result.of(((List)translatedFilters.getOrDefault(true, new ArrayList())).stream().map(t -> (ResolvedExpression)t.f2).collect(Collectors.toList()), filters);
    }

    public int hashCode() {
        return Objects.hash(this.readOptions, this.producedDataType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigQueryDynamicTableSource other = (BigQueryDynamicTableSource)obj;
        return Objects.equals(this.readOptions, other.readOptions) && Objects.equals(this.producedDataType, other.producedDataType);
    }

    Optional<TablePartitionInfo> retrievePartitionInfo() {
        BigQueryConnectOptions connectOptions = this.readOptions.getBigQueryConnectOptions();
        BigQueryServices.QueryDataClient dataClient = BigQueryServicesFactory.instance((BigQueryConnectOptions)connectOptions).queryClient();
        return dataClient.retrievePartitionColumnInfo(connectOptions.getProjectId(), connectOptions.getDataset(), connectOptions.getTable());
    }

    public Optional<List<Map<String, String>>> listPartitions() {
        BigQueryConnectOptions connectOptions = this.readOptions.getBigQueryConnectOptions();
        BigQueryServices.QueryDataClient dataClient = BigQueryServicesFactory.instance((BigQueryConnectOptions)connectOptions).queryClient();
        Optional<List<Map<String, String>>> ret = this.retrievePartitionInfo().map(partitionInfo -> BigQueryDynamicTableSource.transformPartitionIds(connectOptions.getProjectId(), connectOptions.getDataset(), connectOptions.getTable(), partitionInfo, dataClient));
        LOG.info("Partitions with data on the BigQuery table {},", (Object)ret.toString());
        return ret;
    }

    public void applyPartitions(List<Map<String, String>> remainingPartitions) {
        Optional<TablePartitionInfo> partitionInfo = this.retrievePartitionInfo();
        this.readOptions = this.readOptions.toBuilder().setRowRestriction(BigQueryDynamicTableSource.rebuildRestrictionsApplyingPartitions(this.readOptions.getRowRestriction(), partitionInfo, remainingPartitions)).build();
        LOG.info("Partitions to be used {}.", (Object)remainingPartitions.toString());
    }

    private static List<Map<String, String>> transformPartitionIds(String projectId, String dataset, String table, TablePartitionInfo partitionInfo, BigQueryServices.QueryDataClient dataClient) {
        return BigQueryPartitionUtils.partitionValuesFromIdAndDataType((List)dataClient.retrieveTablePartitions(projectId, dataset, table), (StandardSQLTypeName)partitionInfo.getColumnType()).stream().map(pValue -> {
            HashMap<String, String> partitionColAndValue = new HashMap<String, String>();
            partitionColAndValue.put(partitionInfo.getColumnName(), (String)pValue);
            return partitionColAndValue;
        }).collect(Collectors.toList());
    }

    private static String rebuildRestrictionsApplyingPartitions(String currentRestriction, Optional<TablePartitionInfo> partitionInfo, List<Map<String, String>> remainingPartitions) {
        String partitionRestrictions = remainingPartitions.stream().flatMap(map -> map.entrySet().stream()).map(entry -> BigQueryPartitionUtils.formatPartitionRestrictionBasedOnInfo((Optional)partitionInfo, (String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.joining(" OR "));
        return currentRestriction + " AND (" + partitionRestrictions + ")";
    }
}

