/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.table.config;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.connector.base.DeliveryGuarantee;

@PublicEvolving
public class BigQueryConnectorOptions {
    public static final ConfigOption<String> PROJECT = ConfigOptions.key((String)"project").stringType().noDefaultValue().withDescription("Specifies the GCP project for BigQuery.");
    public static final ConfigOption<String> DATASET = ConfigOptions.key((String)"dataset").stringType().noDefaultValue().withDescription("Specifies the BigQuery dataset name.");
    public static final ConfigOption<String> TABLE = ConfigOptions.key((String)"table").stringType().noDefaultValue().withDescription("Specifies the BigQuery table name.");
    public static final ConfigOption<Integer> LIMIT = ConfigOptions.key((String)"read.limit").intType().defaultValue((Object)-1).withDescription("Specifies the limit number of rows retrieved.");
    public static final ConfigOption<Boundedness> MODE = ConfigOptions.key((String)"read.mode").enumType(Boundedness.class).defaultValue((Object)Boundedness.BOUNDED).withDescription("Specifies the read mode - BOUNDED or CONTINUOUS_UNBOUNDED");
    public static final ConfigOption<String> ROW_RESTRICTION = ConfigOptions.key((String)"read.row.restriction").stringType().defaultValue((Object)"").withDescription("Specifies the row restriction for data retrieval.");
    public static final ConfigOption<String> COLUMNS_PROJECTION = ConfigOptions.key((String)"read.columns.projection").stringType().noDefaultValue().withDescription("Specifies, as a comma separated list of values, the columns to be included as part of the data retrieved.");
    public static final ConfigOption<Integer> MAX_STREAM_COUNT = ConfigOptions.key((String)"read.streams.max-count").intType().defaultValue((Object)0).withDescription("The max number of streams used to read from the underlying table, BigQuery can decide for less than this number.");
    public static final ConfigOption<Long> SNAPSHOT_TIMESTAMP = ConfigOptions.key((String)"read.snapshot.timestamp").longType().noDefaultValue().withDescription("The millis since epoch for the underlying table snapshot.");
    public static final ConfigOption<String> CREDENTIALS_ACCESS_TOKEN = ConfigOptions.key((String)"credentials.access-token").stringType().noDefaultValue().withDescription("Specifies the GCP access token to use as credentials.");
    public static final ConfigOption<String> CREDENTIALS_FILE = ConfigOptions.key((String)"credentials.file").stringType().noDefaultValue().withDescription("Specifies the GCP credentials file to use.");
    public static final ConfigOption<String> CREDENTIALS_KEY = ConfigOptions.key((String)"credentials.key").stringType().noDefaultValue().withDescription("Specifies the GCP credentials key to use.");
    public static final ConfigOption<Boolean> TEST_MODE = ConfigOptions.key((String)"test.enabled").booleanType().defaultValue((Object)false).withDescription("Specifies if the connector should run in test mode.");
    public static final ConfigOption<Integer> PARTITION_DISCOVERY_INTERVAL = ConfigOptions.key((String)"read.discovery-interval").intType().defaultValue((Object)10).withDescription("Partition Discovery interval(in minutes)");
    public static final ConfigOption<DeliveryGuarantee> DELIVERY_GUARANTEE = ConfigOptions.key((String)"write.delivery-guarantee").enumType(DeliveryGuarantee.class).defaultValue((Object)DeliveryGuarantee.AT_LEAST_ONCE).withDescription("Delivery Guarantee (AT_LEAST_ONCE or EXACTLY_ONCE");
    public static final ConfigOption<Integer> SINK_PARALLELISM = ConfigOptions.key((String)"write.parallelism").intType().noDefaultValue().withDescription("Sink Parallelism");

    private BigQueryConnectorOptions() {
    }
}

