/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.table.config;

import com.google.cloud.flink.bigquery.table.config.BigQueryConnectorOptions;
import com.google.cloud.flink.bigquery.table.config.BigQueryTableConfig;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.table.api.TableDescriptor;

public class BigQueryReadTableConfig
extends BigQueryTableConfig {
    private final Integer limit;
    private final String rowRestriction;
    private final String columnProjection;
    private final Integer maxStreamCount;
    private final Long snapshotTimestamp;
    private final Boundedness boundedness;
    private final Integer partitionDiscoveryInterval;

    BigQueryReadTableConfig(String project, String dataset, String table, String credentialAccessToken, String credentialFile, String credentialKey, Boolean testMode, String columnProjection, Integer maxStreamCount, String rowRestriction, Integer limit, Long snapshotTimestamp, Boundedness boundedness, Integer partitionDiscoveryInterval) {
        super(project, dataset, table, credentialAccessToken, credentialFile, credentialKey, testMode);
        this.columnProjection = columnProjection;
        this.rowRestriction = rowRestriction;
        this.limit = limit;
        this.maxStreamCount = maxStreamCount;
        this.snapshotTimestamp = snapshotTimestamp;
        this.boundedness = boundedness;
        this.partitionDiscoveryInterval = partitionDiscoveryInterval;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public TableDescriptor updateTableDescriptor(TableDescriptor tableDescriptor) {
        tableDescriptor = super.updateTableDescriptor(tableDescriptor);
        TableDescriptor.Builder tableDescriptorBuilder = tableDescriptor.toBuilder();
        if (this.limit != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.LIMIT, (Object)this.limit);
        }
        if (this.maxStreamCount != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.MAX_STREAM_COUNT, (Object)this.maxStreamCount);
        }
        if (this.columnProjection != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.COLUMNS_PROJECTION, (Object)this.columnProjection);
        }
        if (this.rowRestriction != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.ROW_RESTRICTION, (Object)this.rowRestriction);
        }
        if (this.snapshotTimestamp != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.SNAPSHOT_TIMESTAMP, (Object)this.snapshotTimestamp);
        }
        if (this.boundedness != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.MODE, (Object)this.boundedness);
        }
        if (this.partitionDiscoveryInterval != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.PARTITION_DISCOVERY_INTERVAL, (Object)this.partitionDiscoveryInterval);
        }
        return tableDescriptorBuilder.build();
    }

    public static class Builder
    extends BigQueryTableConfig.Builder {
        private Integer limit;
        private String rowRestriction;
        private String columnProjection;
        private Integer maxStreamCount;
        private Long snapshotTimestamp;
        private Boundedness boundedness;
        private Integer partitionDiscoveryInterval;

        @Override
        public Builder project(String project) {
            this.project = project;
            return this;
        }

        @Override
        public Builder dataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public Builder table(String table) {
            this.table = table;
            return this;
        }

        @Override
        public Builder credentialAccessToken(String credentialAccessToken) {
            this.credentialAccessToken = credentialAccessToken;
            return this;
        }

        @Override
        public Builder credentialKey(String credentialKey) {
            this.credentialKey = credentialKey;
            return this;
        }

        @Override
        public Builder credentialFile(String credentialFile) {
            this.credentialFile = credentialFile;
            return this;
        }

        @Override
        public Builder testMode(Boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder rowRestriction(String rowRestriction) {
            this.rowRestriction = rowRestriction;
            return this;
        }

        public Builder columnProjection(String columnProjection) {
            this.columnProjection = columnProjection;
            return this;
        }

        public Builder maxStreamCount(Integer maxStreamCount) {
            this.maxStreamCount = maxStreamCount;
            return this;
        }

        public Builder snapshotTimestamp(Long snapshotTimestamp) {
            this.snapshotTimestamp = snapshotTimestamp;
            return this;
        }

        public Builder boundedness(Boundedness boundedness) {
            this.boundedness = boundedness;
            return this;
        }

        public Builder partitionDiscoveryInterval(Integer partitionDiscoveryInterval) {
            this.partitionDiscoveryInterval = partitionDiscoveryInterval;
            return this;
        }

        public BigQueryReadTableConfig build() {
            return new BigQueryReadTableConfig(this.project, this.dataset, this.table, this.credentialAccessToken, this.credentialFile, this.credentialKey, this.testMode, this.columnProjection, this.maxStreamCount, this.rowRestriction, this.limit, this.snapshotTimestamp, this.boundedness, this.partitionDiscoveryInterval);
        }
    }
}

