/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.table.config;

import com.google.cloud.flink.bigquery.sink.BigQuerySinkConfig;
import com.google.cloud.flink.bigquery.table.config.BigQueryConnectorOptions;
import com.google.cloud.flink.bigquery.table.config.BigQueryTableConfig;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableDescriptor;

public class BigQuerySinkTableConfig
extends BigQueryTableConfig {
    private final DeliveryGuarantee deliveryGuarantee;
    private final Integer sinkParallelism;

    BigQuerySinkTableConfig(String project, String dataset, String table, String credentialAccessToken, String credentialFile, String credentialKey, boolean testMode, DeliveryGuarantee deliveryGuarantee, Integer sinkParallelism) {
        super(project, dataset, table, credentialAccessToken, credentialFile, credentialKey, testMode);
        this.deliveryGuarantee = deliveryGuarantee;
        this.sinkParallelism = sinkParallelism;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public TableDescriptor updateTableDescriptor(TableDescriptor tableDescriptor) {
        tableDescriptor = super.updateTableDescriptor(tableDescriptor);
        TableDescriptor.Builder tableDescriptorBuilder = tableDescriptor.toBuilder();
        if (this.deliveryGuarantee != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.DELIVERY_GUARANTEE, (Object)this.deliveryGuarantee);
        }
        if (this.sinkParallelism != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.SINK_PARALLELISM, (Object)this.sinkParallelism);
        }
        return tableDescriptorBuilder.build();
    }

    public static class Builder
    extends BigQueryTableConfig.Builder {
        private DeliveryGuarantee deliveryGuarantee;
        private Integer sinkParallelism;
        private StreamExecutionEnvironment env;

        @Override
        public Builder project(String project) {
            this.project = project;
            return this;
        }

        @Override
        public Builder dataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public Builder table(String table) {
            this.table = table;
            return this;
        }

        @Override
        public Builder credentialAccessToken(String credentialAccessToken) {
            this.credentialAccessToken = credentialAccessToken;
            return this;
        }

        @Override
        public Builder credentialKey(String credentialKey) {
            this.credentialKey = credentialKey;
            return this;
        }

        @Override
        public Builder credentialFile(String credentialFile) {
            this.credentialFile = credentialFile;
            return this;
        }

        @Override
        public Builder testMode(Boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public Builder deliveryGuarantee(DeliveryGuarantee deliveryGuarantee) {
            this.deliveryGuarantee = deliveryGuarantee;
            return this;
        }

        public Builder sinkParallelism(Integer sinkParallelism) {
            this.sinkParallelism = sinkParallelism;
            return this;
        }

        public Builder streamExecutionEnvironment(StreamExecutionEnvironment streamExecutionEnvironment) {
            this.env = streamExecutionEnvironment;
            return this;
        }

        public BigQuerySinkTableConfig build() {
            if (this.deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE) {
                BigQuerySinkConfig.validateStreamExecutionEnvironment(this.env);
            }
            return new BigQuerySinkTableConfig(this.project, this.dataset, this.table, this.credentialAccessToken, this.credentialFile, this.credentialKey, this.testMode, this.deliveryGuarantee, this.sinkParallelism);
        }
    }
}

