/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.table.config;

import com.google.cloud.flink.bigquery.table.config.BigQueryConnectorOptions;
import org.apache.flink.table.api.TableDescriptor;

public abstract class BigQueryTableConfig {
    private final String project;
    private final String dataset;
    private final String table;
    private final String credentialAccessToken;
    private final String credentialFile;
    private final String credentialKey;
    private final Boolean testMode;

    BigQueryTableConfig(String project, String dataset, String table, String credentialAccessToken, String credentialFile, String credentialKey, Boolean testMode) {
        this.project = project;
        this.dataset = dataset;
        this.table = table;
        this.credentialAccessToken = credentialAccessToken;
        this.credentialFile = credentialFile;
        this.credentialKey = credentialKey;
        this.testMode = testMode;
    }

    public TableDescriptor updateTableDescriptor(TableDescriptor tableDescriptor) {
        TableDescriptor.Builder tableDescriptorBuilder = tableDescriptor.toBuilder();
        if (this.table != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.TABLE, (Object)this.table);
        }
        if (this.project != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.PROJECT, (Object)this.project);
        }
        if (this.dataset != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.DATASET, (Object)this.dataset);
        }
        if (this.credentialKey != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.CREDENTIALS_KEY, (Object)this.credentialKey);
        }
        if (this.credentialFile != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.CREDENTIALS_FILE, (Object)this.credentialFile);
        }
        if (this.credentialAccessToken != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.CREDENTIALS_ACCESS_TOKEN, (Object)this.credentialAccessToken);
        }
        if (this.testMode != null) {
            tableDescriptorBuilder.option(BigQueryConnectorOptions.TEST_MODE, (Object)this.testMode);
        }
        return tableDescriptorBuilder.build();
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getTable() {
        return this.table;
    }

    public String getProject() {
        return this.project;
    }

    public String getCredentialAccessToken() {
        return this.credentialAccessToken;
    }

    public String getCredentialFile() {
        return this.credentialFile;
    }

    public String getCredentialKey() {
        return this.credentialKey;
    }

    public static abstract class Builder {
        String project;
        String dataset;
        String table;
        String credentialAccessToken;
        String credentialFile;
        String credentialKey;
        boolean testMode;

        public abstract Builder project(String var1);

        public abstract Builder dataset(String var1);

        public abstract Builder table(String var1);

        public abstract Builder credentialAccessToken(String var1);

        public abstract Builder credentialKey(String var1);

        public abstract Builder credentialFile(String var1);

        public abstract Builder testMode(Boolean var1);
    }
}

