/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.flink.bigquery.table.config;

import com.google.cloud.flink.bigquery.common.config.BigQueryConnectOptions;
import com.google.cloud.flink.bigquery.common.config.CredentialsOptions;
import com.google.cloud.flink.bigquery.services.BigQueryServices;
import com.google.cloud.flink.bigquery.source.config.BigQueryReadOptions;
import com.google.cloud.flink.bigquery.table.config.BigQueryConnectorOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.util.function.SerializableSupplier;

@Internal
public class BigQueryTableConfigurationProvider {
    private final ReadableConfig config;
    private Optional<SerializableSupplier<BigQueryServices>> testingServices = Optional.empty();

    public BigQueryTableConfigurationProvider(ReadableConfig config) {
        this.config = config;
    }

    public BigQueryTableConfigurationProvider withTestingServices(SerializableSupplier<BigQueryServices> testingServices) {
        this.testingServices = Optional.of(testingServices);
        return this;
    }

    public boolean isTestModeEnabled() {
        return (Boolean)this.config.get(BigQueryConnectorOptions.TEST_MODE);
    }

    public boolean isUnboundedEnabled() {
        return this.config.get(BigQueryConnectorOptions.MODE) == Boundedness.CONTINUOUS_UNBOUNDED;
    }

    public Optional<Integer> getParallelism() {
        return Optional.ofNullable(this.config.get(BigQueryConnectorOptions.SINK_PARALLELISM));
    }

    public BigQueryReadOptions toBigQueryReadOptions() {
        return BigQueryReadOptions.builder().setSnapshotTimestampInMillis((Long)this.config.get(BigQueryConnectorOptions.SNAPSHOT_TIMESTAMP)).setMaxStreamCount((Integer)this.config.get(BigQueryConnectorOptions.MAX_STREAM_COUNT)).setRowRestriction((String)this.config.get(BigQueryConnectorOptions.ROW_RESTRICTION)).setColumnNames((List)Optional.ofNullable(this.config.get(BigQueryConnectorOptions.COLUMNS_PROJECTION)).map(cols -> Arrays.asList(cols.split(","))).orElse(new ArrayList())).setBigQueryConnectOptions(this.translateBigQueryConnectOptions()).setLimit((Integer)this.config.get(BigQueryConnectorOptions.LIMIT)).setPartitionDiscoveryRefreshIntervalInMinutes((Integer)this.config.get(BigQueryConnectorOptions.PARTITION_DISCOVERY_INTERVAL)).build();
    }

    public BigQueryConnectOptions translateBigQueryConnectOptions() {
        return BigQueryConnectOptions.builder().setProjectId((String)this.config.get(BigQueryConnectorOptions.PROJECT)).setDataset((String)this.config.get(BigQueryConnectorOptions.DATASET)).setTable((String)this.config.get(BigQueryConnectorOptions.TABLE)).setTestingBigQueryServices((SerializableSupplier)this.testingServices.orElse(null)).setCredentialsOptions(CredentialsOptions.builder().setAccessToken((String)this.config.get(BigQueryConnectorOptions.CREDENTIALS_ACCESS_TOKEN)).setCredentialsFile((String)this.config.get(BigQueryConnectorOptions.CREDENTIALS_FILE)).setCredentialsKey((String)this.config.get(BigQueryConnectorOptions.CREDENTIALS_KEY)).build()).build();
    }

    public DeliveryGuarantee translateDeliveryGuarantee() {
        return (DeliveryGuarantee)this.config.get(BigQueryConnectorOptions.DELIVERY_GUARANTEE);
    }
}

